const system=require("../../system");
const settings=require("../../../config/settings");
const uiconfig=system.getUiConfig2(settings.wxconfig.appId);
module.exports = (db, DataTypes) => {
    //交易专场
    return db.define("transactionspecialperformance", {
        // 引用表的信息:
        // this.db.models.transactionspecialperformance.belongsTo(this.db.models.company, { as: 'createcompany',constraints: false, });//来源，默认1即平台
        // this.db.models.transactionspecialperformance.belongsTo(this.db.models.user, { as: 'createuser',constraints: false, });//
        // this.db.models.transactionspecialperformance.belongsTo(this.db.models.user, { as: 'updateuser', constraints: false, });
        code: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        name: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        logo_img: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        banner_img: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        content: {//内容 冗余
            type: DataTypes.TEXT('long'),
            allowNull: true,
        },
        desc: {//备注 冗余
            type: DataTypes.STRING,
            allowNull: true,
        },
        ncl_one_codes: {//尼斯大类
            type: DataTypes.STRING,
            allowNull: true,
        },
        orderNo:{//排序序号
          type:DataTypes.INTEGER,
          allowNull: false,
          defaultValue:0
        },
        isReleased: {//是否发布
            type: DataTypes.BOOLEAN,
            defaultValue: false
        },
        siteTheme: {
            //站点主题类型: spring: 春天, summer: 夏天, autumn: 秋天, winter: 冬天
            type: DataTypes.ENUM,
            values: Object.keys(uiconfig.config.pdict.site_theme),
            set: function (val) {
                this.setDataValue("siteTheme", val);
                this.setDataValue("siteThemeName", uiconfig.config.pdict.site_theme[val]);
            },
        },
        siteThemeName: {//站点主题名称
         type: DataTypes.STRING,
        },
        backgroundColor: {//专场背景颜色
         type: DataTypes.STRING,
         defaultValue: "#ffffff"
        },
        fontColor: {//专场字体颜色
         type: DataTypes.STRING,
         defaultValue: "#ffffff"
        },
    }, {
        paranoid: true,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        //freezeTableName: true,
        // define the table's name
        tableName: 'bi_tmt_special_performance',
        validate: {},
        indexes: [
           
        ]
    });
}
