const system=require("../system")
const logCtl=system.getObject("web.oplogCtl");
class TaskBase{
  constructor(className){
     this.redisClient=system.getObject("util.redisClient");
     this.serviceName=className;
  }
  async doTask(){
    try {
      await this.subDoTask();
      //日志记录
      logCtl.info({
         optitle:this.serviceName+"，任务成功执行完成",
         op:"base/db/task.base.js",
         content:"",
         clientIp:""
       });
    } catch (e) {
      //日志记录
      logCtl.error({
         optitle:this.serviceName+"任务执行异常",
         op:"base/db/task.base.js",
         content:e.stack,
         clientIp:""
       });
    }
  }
  async subDoTask(){
    console.log("请在子类中重写此方法进行操作业务逻辑............................!");
  }
  static getServiceName(ClassObj){
    return ClassObj["name"];
  }
}
module.exports=TaskBase;
