const system = require("../../system");
const ServiceBase = require("../sve.base")
const settings = require("../../../config/settings")
class ProducttypeService extends ServiceBase {
    constructor() {
        super(ServiceBase.getDaoName(ProducttypeService));
        this.serviceitemSve = system.getObject("service.serviceitemSve");
    }
    async findAll(obj) {
        return await this.dao.model.findAll({ where: obj, raw: true, order: [["orderNo", "asc"]] });
    }
    /**
     * 获取产品一类列表及其产品
     * @param {*} obj 
     * @param {*} op_type 1为获取一类列表，2查询某一类下的所有产品信息，3为获取一类列表及其产品
     */
    async getTypeOneByCompanyId(obj, op_type) {
        var opType = op_type || 1;
        var companyId = obj.company_id;
        if (!companyId) {
            return { code: -102, msg: "companyId参数错误" };
        }
        var tbDataList = await this.cacheManager["ProductListCache"].getProductListByCache(companyId);
        if (!tbDataList || tbDataList.length == 0) {
            return { code: 1, data: null };
        }
        var result = [];
        for (let index = 0; index < tbDataList.length; index++) {
            var element = tbDataList[index];
            if (element) {
                if (opType == 1) {
                    delete element.smallList;
                    result.push(element);
                    continue;
                }//获取一类列表
                if (opType == 2) {
                    if (element.itemType == obj.typeCode) {
                        result.push(element);
                        break;
                    }
                    continue;
                }//查询某一类下的所有产品信息

                var tmpList = [];
                if (element.smallList && element.smallList.length > 0) {
                    for (let j = 0; j < element.smallList.length; j++) {
                        const tmpItem = element.smallList[j];
                        if (tmpItem && tmpItem.productList && tmpItem.productList.length > 0) {
                            tmpList.push.apply(tmpList, tmpItem.productList);
                        }
                    }
                }
                if (tmpList.length > 0) {
                    if (element.itemType == "ip") {
                        var tIndex1 = tmpList.findIndex(f => f.code == "zzsbzc");
                        if (tIndex1 >= 0) {
                            tmpList.splice(tIndex1, 1);
                        }
                        var tIndex2 = tmpList.findIndex(v => v.code === "dlrfzzc");
                        if (tIndex2 >= 0) {
                            tmpList.splice(tIndex2, 1);
                        }
                        var tIndex3 = tmpList.findIndex(v => v.code === "dbsbzc");
                        if (tIndex3 >= 0) {
                            tmpList.splice(tIndex3, 1);
                        }
                    }//移除商标注册、代理人辅助注册
                    if (tmpList.length > 0) {
                        result.push({
                            id: element.id,
                            code: element.itemType,
                            name: element.itemTypeName,
                            oneIconUrl: element.oneIconUrl,
                            productList: tmpList
                        });
                    }

                }
            }
        }
        return { code: 1, data: result };
    }

    async getAllProducts(obj){
        var companyId = obj.companyId;
        if(!companyId){
            return {code:-1,msg:"企业信息错误"};
        }
        var sql = "select item.`id`,item.`code`, item.`name`, item.itemType, item.itemTypeName, item.producttype_pid_id, item.producttype_id,"+
        "a.code as typecode1,a.name as typename1, b.code as typecode2,b.name as typename2 from "+
        "(SELECT id,code, name, itemType, itemTypeName, producttype_pid_id, producttype_id "+
        "FROM `s_serviceitem` WHERE company_id = "+companyId+" AND isPubed = 1) as item "+
        " LEFT JOIN "+
        " (select id,name,code from s_producttype) as a on a.id=item.producttype_id "+
        " LEFT JOIN (select id,name,code from s_producttype) as b on b.id=item.producttype_pid_id ";
        var dataList = await this.dao.customQuery(sql);
        var list=[];
        var type2List=[];
        var resultList=[];
        for(var i=0;i<dataList.length;i++){
            var d = dataList[i];
            if(d.typecode1){
                var index = list.indexOf(d.typecode1);
                if(index<0){
                    list.push(d.typecode1);
                    var type2obj={code:d.typecode1,name:d.typename1,pcode:d.typecode2,pname:d.typename2,children:[{name:d.name,code:d.code,id:d.id}]};
                    type2List.push(type2obj);
                }else{
                    type2List[index].children.push({name:d.name,code:d.code,id:d.id});
                }
            }
        }
        list=[];
        for(var i=0;i<type2List.length;i++){
            var d = type2List[i];
            if(d.pcode){
                var index = list.indexOf(d.pcode);
                if(index<0){
                    list.push(d.pcode);
                    var resobj={code:d.pcode,name:d.pname,children:[d]};
                    resultList.push(resobj);
                }else{
                    resultList[index].children.push(d);
                }
            }
        }
        var res = {code:1,data:resultList};
        return res;
    }

}
module.exports = ProducttypeService;
// var task = new ProducttypeService();
// var obj={companyId:4};
// task.getAllProducts(obj).then(d=>{
//     console.log("ddddddddddddddddd");
//     console.log(JSON.stringify(d));
// })