const system = require("../../system");
const ServiceBase = require("../sve.base")
const settings = require("../../../config/settings")
class ReceiptVoucherService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(ReceiptVoucherService));
    this.moneyjourneyDao = system.getObject("db.moneyjourneyDao");
    this.moneyaccountDao = system.getObject("db.moneyaccountDao");
    this.orderDao = system.getObject("db.orderDao");
    this.orderflowDao = system.getObject("db.orderflowDao");
  }
  async afteraudit(obj, tm) {
    var item = await this.moneyjourneyDao.model.findOne({ where: { code: obj.code }, raw: true });
    if (!item) {
      throw new Error("账单信息有误");
    }
    if (item.auditStatus != "dsh") {
      throw new Error("账单信息状态不是待审核状态,无法进行操作");
    }
    await this.moneyjourneyDao.update({ id: item.id, auditStatus: obj.auditStatus, opNotes: obj.opNotes }, tm);
    if (obj.sourceType == "order") {
      var orderInfo = await this.orderDao.model.findOne({
        where: { code: obj.sourceOrderNo }, attributes: ["id", "sveItemCode", "company_id", "createuser_id"], raw: true
      });
      if (!orderInfo) {
        throw new Error("订单信息有误");
      }
      var setOrderParams = { id: orderInfo.id, auditStatus: obj.auditStatus, opNotes: obj.opNotes };
      if (obj.auditStatus == "tg") {
        var moneyaccountinfo = await this.moneyaccountDao.model.findOne({ where: { id: item.moneyaccount_id }, raw: true });
        if (moneyaccountinfo) {
          var opMoney = item.directionType == "sr" ? item.recvAmount : item.payAmount;
          var balanceSum = Number(moneyaccountinfo.balance) + Number(opMoney);
          await this.moneyaccountDao.update({ id: moneyaccountinfo.id, balance: balanceSum }, tm);
        }
        if (orderInfo.sveItemCode != "dlrfzzc" && orderInfo.sveItemCode != "zzsbzc" && orderInfo.sveItemCode != "dbsbzc") {
          setOrderParams["orderStatus"] = "5";
          setOrderParams["orderFlowStatus"] = "3";
        } else {
          setOrderParams["orderFlowStatus"] = "2";
        }
        setOrderParams["orderPayStatus"] = "yfk";
      } else {
        setOrderParams["orderPayStatus"] = "pzshwtg";
      }
      await this.orderDao.update(setOrderParams, tm);
      var opMsg = obj.auditStatus == "tg" ? "线下支付凭证通过审核" : ("线下支付凭证未通过审核，原因为" + obj.opNotes);
      //订单流程log
      this.orderflowDao.create({
        company_id: orderInfo.company_id,
        createuser_id: orderInfo.createuser_id,
        sourceOrderNo: obj.sourceOrderNo,
        opContent: opMsg,
      }, tm);

    }
  }
  async aftercreate(result, tm) {
    var obj = {
      accountType: result.accountType || "bank",//帐户类型:"cash": "现金", "bank": "银行" ,"wx":"微信","alipay":"支付宝","other":"其它"
      code: result.code,
      directionType: "sr",
      voucherDate: result.created_at,
      recvAmount: result.totalSum,
      payAmount: 0,
      sourceType: "receiptvoucher",
      sourceOrderNo: result.sourceOrderNo,
      notes: result.notes,
      createuser_id: result.createuser_id,
      moneyaccount_id: result.moneyaccount_id,
      auditStatus: result.auditStatus,
      company_id: result.company_id,
      createcompany_id: result.createcompany_id,
    };
    if (result.receiptType == "tk") {
      obj.directionType = "zc";
      obj.recvAmount = 0;
      obj.payAmount = result.totalSum;
    } else {
      obj.recvAmount = result.totalSum;
    }
    await this.moneyjourneyDao.create(obj, tm);
  }
  async beforedelete(result, tm) {
    var obj = await this.dao.findOne({ id: result.id });
    var moneyjourneyinfo = await this.moneyjourneyDao.findOne({ sourceOrderNo: obj.id });
    await this.moneyjourneyDao.delete(result, tm);
    var moneyaccountinfo = await this.moneyaccountDao.findOne({ id: obj.moneyaccount_id });
    var p = moneyaccountinfo.get({ raw: true });
    console.log(p);
    var num = Number(p.balance) - Number(obj.totalSum);
    await this.moneyaccountDao.update({ id: p.id, balance: num }, tm);
  }

}
module.exports = ReceiptVoucherService;
