const system = require("../../system");
const ServiceBase = require("../sve.base");
const settings = require("../../../config/settings");
var moment = require('moment');
const claimAddHours = 72;//认领添加的时间（单位小时）=3天
const protectAddHours = 168;//保护添加的时间（单位小时）=7天
const uiconfig = system.getUiConfig2(settings.wxconfig.appId);
var xlsx = require('node-xlsx');
var fs = require("fs");
class TrademarktransactionneedService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(TrademarktransactionneedService));
    this.uploadCtl = system.getObject("web.uploadCtl");
    this.trademarktransactionSve = system.getObject("service.trademarktransactionSve");
  }
  async submitNeed(obj){
    var code = obj.code;
    var buyer_name = obj.buyer_name;
    var buyer_mobile = obj.buyer_mobile;
    var buyer_quoted_price = obj.buyer_quoted_price;
    if(!code){
      return {code:-2,msg:"code参数错误"};
    }
    if(!buyer_name){
      return {code:-3,msg:"buyer_name参数错误"};
    }
    if(!buyer_mobile){
      return {code:-4,msg:"buyer_mobile参数错误"};
    }
    if(!buyer_quoted_price){
      return {code:-5,msg:"buyer_quoted_price参数错误"};
    }
    var tmts = await this.trademarktransactionSve.dao.model.findAll({where:{code:code},raw:true});
    console.log(tmts);
    if(!tmts || tmts.length<1){
      return {code:-6,msg:"商标数据不存在"};
    }
    var tmt = tmts[0];
    var ncl_one_code = "";
    for(var i=0;i<tmts.length;i++){
      if(tmts[i].ncl_one_code){
        ncl_one_code=ncl_one_code+tmts[i].ncl_one_code+";"
      }
    }
    var tmtn = await this.dao.model.findOne({where:{trademarktransaction_id:tmt.id,buyer_mobile:buyer_mobile},raw:true});
    if(tmtn){
      return {code:-7,msg:"您已经提交过此需求，我们的业务员会尽快联系您，请耐心等待"};
    }
    var needObj={company_id:tmt.createcompany_id,
      buyer_name:buyer_name,buyer_mobile:buyer_mobile,buyer_quoted_price:buyer_quoted_price,
      tm_name:tmt.name,tm_code:tmt.code,ncl_one_code:ncl_one_code,tm_applier:tmt.tm_applier,
      platform_quoted_price:tmt.platform_quoted_price,tmowner_id:tmt.createuser_id,trademarktransaction_id:tmt.id
    }
    var need = await this.dao.create(needObj);
    return {code:1,data:need};
    
  }

}
module.exports = TrademarktransactionneedService;
// var test = new TrademarktransactionneedService();
// var obj={
//   code:"23011401",
//   buyer_name:"测试姓名",
//   buyer_mobile:"13075556693",
//   buyer_quoted_price:"5000",
// }
// test.submitNeed(obj).then(function(d){
//   console.log("#################################");
//   console.log(d);
// })
