var app = new Vue({
    el:"#app",
    data:function(a){
      return {
        currentPage:"0",
        code:"",
        openid:"",
        orderNum:"",
        orderInfo:{},
        customerinfo:{},
        tmstuffs:[],
        trademarks:[],
        trademark:{},
        payType:"",
        d:{},
        action:"",
        zfpzUrl:"",
        accounts:[],
        account_id:"",
        qrcode:"",
        tradekey:"",
        time:"",
        interval:null,
        isLogin:false,
        opath:"",
        subfix:"",
        w_height:0,
        ncldata:[
            {code:"01",name:"化学原料"},{code:"02",name:"颜料油漆"},{code:"03",name:"日化用品"},{code:"04",name:"燃料油脂"},{code:"05",name:"医药"},
            {code:"06",name:"金属材料"},{code:"07",name:"机械设备"},{code:"08",name:"手工器械"},{code:"09",name:"科学仪器"},{code:"10",name:"医疗器械"},
            {code:"11",name:"灯具空调"},{code:"12",name:"运输工具"},{code:"13",name:"军火烟火"},{code:"14",name:"珠宝钟表"},{code:"15",name:"乐器"},
            {code:"16",name:"办公用品"},{code:"17",name:"橡胶制品"},{code:"18",name:"皮革皮具"},{code:"19",name:"建筑材料"},{code:"20",name:"家具"},
            {code:"21",name:"厨房洁具"},{code:"22",name:"绳网袋篷"},{code:"23",name:"纱线丝"},{code:"24",name:"布料床单"},{code:"25",name:"服装鞋帽"},
            {code:"26",name:"纽扣拉链"},{code:"27",name:"地毯席垫"},{code:"28",name:"健身器材"},{code:"29",name:"食品"},{code:"30",name:"方便食品"},
            {code:"31",name:"饲料种籽"},{code:"32",name:"啤酒饮料"},{code:"33",name:"酒"},{code:"34",name:"烟草烟具"},{code:"35",name:"广告销售"},
            {code:"36",name:"金融物管"},{code:"37",name:"建筑修理"},{code:"38",name:"通讯服务"},{code:"39",name:"运输贮藏"},{code:"40",name:"材料加工"},
            {code:"41",name:"教育娱乐"},{code:"42",name:"网站服务"},{code:"43",name:"餐饮住宿"},{code:"44",name:"医疗园艺"},{code:"45",name:"社会服务"}
  
        ],
      }
  
    },
    created:function(){
      var that=this;
      console.log(window.location.search);
      var orderNum =window.location.search.substr(1).match(new RegExp("(^|&)" + "state" + "=([^&]*)(&|$)", "i"));
      if(orderNum){
        var data = orderNum[2];
        data = decodeURIComponent(data);
        this.orderNum = data;
        this.opath="https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx4c91e81bbb6039cd&redirect_uri=https%3A%2F%2Figirl.gongsibao.com%2Forderpay%2Forderpay&response_type=code&scope=snsapi_base&state="+data+"&connect_redirect=1#wechat_redirect";
      }else{
        this.$message.warning("订单参数错误");
        return;
      }
      var code =window.location.search.substr(1).match(new RegExp("(^|&)" + "code" + "=([^&]*)(&|$)", "i"));
      if(code){
        var data = code[2];
        data = decodeURIComponent(data);
        this.code = data;
        // this.getOpenId();
        if(!this.openid){
          this.getOpenId();
        }
      }else{
        window.location.href=this.opath;
      }
      
    },
    mounted:function(){
        if(!this.code){
            return;
        }
        this.initWxJsApi();
        this.w_height = window.innerHeight;
        var that=this;
        this.getReq("/web/orderCtl/getTmOrderDetail", {orderNum:this.orderNum}).then(function (d) {
            if(d.code==1){
                if(d.data.trademarks && d.data.trademarks.length>0){
                    that.trademark = d.data.trademarks[0];
                    for(var i=0;i<d.data.trademarks.length;i++){
                        var nclSmallCodes = d.data.trademarks[i].nclSmallCodes;
                        if(nclSmallCodes){
                            var nclThrees = JSON.parse(nclSmallCodes);
                            d.data.trademarks[i]["nclThrees"]=nclThrees;
                        }
                        var name = that.ncldata[Number(d.data.trademarks[i].nclOneCodes)-1].name;
                        d.data.trademarks[i]["nclOneCodeName"]=name;

                    }
                }
                for(var j=0;j<d.data.tmstuffs.length;j++){
                  if(d.data.tmstuffs[j].stuffType=="ty"){
                    that.trademark["picUrl"]=d.data.tmstuffs[j].stuffUrl;
                  }
                  if(d.data.tmstuffs[j].stuffType=="csty"){
                    that.trademark["colorPicUrl"]=d.data.tmstuffs[j].stuffUrl;
                  }
                }
                that.orderInfo=d.data.order;
                that.customerinfo=d.data.customerinfo;
                that.tmstuffs=d.data.tmstuffs;
                that.trademarks=d.data.trademarks;
                if(d.data.order){
                  if(d.data.order.sveItemCode=="dlrfzzc" || d.data.order.sveItemCode=="zzsbzc"){
                    that.currentPage=1;
                  }else if(d.data.order.orderPayStatus=="dfk"){
                    that.currentPage=2;
                  }else if(d.data.order.orderPayStatus=="yfk"){
                    that.currentPage=3;
                  }
                }
                
            }

        });
        this.postReq("/web/uploadCtl/getOssConfig","").then(function(d){
            that.d["key"]="key";
            that.d["Bucket"]=d.Bucket;
            that.d["OSSAccessKeyId"]=d.OSSAccessKeyId;
            that.d["Signature"]=d.Signature;
            that.d["policy"]=d.policy;
            that.d["success_action_status"]=d.success_action_status;
            that.action=d.url;
        });

    },
    methods:{
      getOpenId(){
        var self =this;
        this.getReq("/web/wxCtl/getToken",{code:this.code}).then(function(d){
          console.log(d);
          if(d && d.code==1){
            self.openid=d.data.openid;
          }else{
            window.location.href=self.opath;
          }
        }).catch(e=>{
          window.location.href=self.opath;
        });
      },
      postReq(path,data){
        return axios.post(path,data).then(function(r){
          return r.data?r.data:null;
        })
      },
      getReq(path, data) {
        var self = this;
        return new Promise(function(resv,reject){
          axios.get(path, { params: data, "headers": { "codepath": self.currentCodePath, "companyid": self.currentCompany ? self.currentCompany.id : "" } }).then(function (r) {
            resv(r.data ? r.data : null);
          }).catch(function(e){
            reject(e);
          });
        });

      },
      fetchOAuthPath(){
        var self =this;
        console.log("22222222222222");
        this.postReq("/web/wxCtl/fetchOAuthPath",{subfix:this.orderNum}).then(function(d){
          if(d && d.status==0){
              self.opath=d.data;
              console.log("11111111111111111111111111111111111111111111");
              console.log(self.opath);
              window.location.href=d.data;
          }
        });
      },
      nextStep(){
        if(this.openid){
          if(this.orderInfo.orderPayStatus=="yfk"){
            $('title').text('订单支付');
            this.currentPage=3;
          }else if(this.orderInfo.orderPayStatus=="dfk"){
            $('title').text('订单支付');
            this.currentPage=2;
          }
        }
        
      },
      showMask() {
        var self = this;
        setTimeout((function () {
          self.loading = true;
        }), 10);
      },
      hideMask() {
        var self = this;
        setTimeout((function () {
          self.loading = false;
        }), 10);
      },
      initWxJsApi(){
        this.postReq("/web/wxCtl/getJsApiConfig",{url:"https://igirl.gongsibao.com/orderpay"}).then(function(d){
          console.log("d");  
          console.log(d);   
        if(d && d.status==0){
             console.log(d.data);
             var config={};
             config.debug=false;
             config.appId=d.data.appid;
             config.timestamp=d.data.timestamp;
             config.nonceStr=d.data.nonceStr;
             config.signature=d.data.signature;
             config.jsApiList=['checkJsApi','chooseWXPay'];
             wx.config(config);
             wx.ready(function(){
                console.log("微信jsapi已经就续.........");
             });
             wx.error(function(e){
                console.log(e);
             });

           }
        }).catch(e=>{
          console.log(e);
        });
     },
      orderPay(){
        var that=this;
        console.log("!!!!!!!!!!!!!!!!!!");
        this.showMask();
        var obj={order:this.orderInfo,openid:this.openid};
        this.postReq("/web/wxCtl/createWxJsUnifiedOrder",obj).then(d=>{
          var self = that;
          if(d && d.code==1){
            var data = d.data;
            var wxpayParam = data.wxpayParam;
            if(wxpayParam && wxpayParam.nonceStr){
              wx.chooseWXPay({
                timestamp: wxpayParam.timeStamp,
                nonceStr: wxpayParam.nonceStr,
                package:wxpayParam.package,
                signType: wxpayParam.signType,
                paySign: wxpayParam.paySign,
                success: function (res) {
                  console.log("支付成功");
                  if(res.errMsg=="chooseWXPay:ok"){
                    self.getPaidOrder();
                  }else{
                    console.log("支付失败");
                    that.hideMask();
                  }
  
                },
                fail:function(e){
                  console.log(e);
                  that.hideMask();
                },
                complete:function(res){
                  console.log(res);
                }
              });
            }else{
              that.hideMask();
            }
          }else{
            that.$message.warning(d.msg);
            that.hideMask();
          }
        })
    },
    getPaidOrder(){
      var that=this;
      that.showMask();
      var inth= setInterval(function () {
        that.getReq("/web/wxCtl/getPaidOrder",{orderNum:that.orderInfo.code}).then(dd=>{
          if(dd && dd.code==1){
            that.orderInfo=dd.data;
            that.hideMask();
            $('title').text('订单支付');
            that.currentPage=3;
            clearInterval(inth);
          }
        });
      },3000);

    },
  }
});
  