{
  template: '${tmpl}',
    data: function() {
      var that = this;
      var validateMethod = function (rule, value, callback) {
        if (rule.field == "customerMobile") {
          if (/^1[23456789]\d{9}$/.test(value) == false) {
            return callback(new Error("请输入正确格式的手机号"));
          } else {
            return callback();
          }
        }
        return callback();
      };
      var validateTmname = (rule, value, callback) => {
        console.log(this.itemtype);
        console.log(value);
        if (this.itemtype == "ip" && value === "") {
          return callback(new Error('请输入商标名称'));
        } else {
          return callback();
        }
      };
      var validateApplynum = (rule, value, callback) => {
        console.log(this.itemtype);
        console.log(value);
        if (this.itemtype == "ip" && value === "") {
          return callback(new Error('请输入商标申请号'));
        } else {
          return callback();
        }
      };
      return {
        activeIndex: "0",
        index: 0,
        datalist: [],
        form1: {
          productType: "",
          tmname: "",
          price: "",
          applynum: ""
        },
        form2: {
          customerName: "",
          customerMobile: "",
          customerEmail: ""
        },
        itemtype: "",
        productType: [],
        product: {},
        totalTaxes: "",
        totalDiscounts: "",
        totalProfitSum: "",
        rules1: {
          productType: [
            { required: true, message: '请选择业务类型', trigger: 'blur' }
          ],
          price: [
            { required: true, message: '请输入订单价格', trigger: 'blur' }
          ],
          tmname: [
            { validator: validateTmname, trigger: 'blur' }
          ],
          applynum: [
            { validator: validateApplynum, trigger: 'blur' },
          ]
        },
        rules2: {
          customerName: [
            { required: true, message: '请输入客户姓名', trigger: 'blur' }
          ],
          customerMobile: [
            { required: true, message: '请输入客户电话', trigger: 'blur' },
            { validator: validateMethod, trigger: 'blur' },
          ],
          customerEmail: [
            /* { required: true, message: '请输入客户邮箱', trigger: 'blur' }*/
          ]
        }
      }
    },
  mounted: function() {

  },
  created: function() {

    var that = this;
    this.$root.getReq("/web/producttypeCtl/getTypeOneByCompanyId", {}).then(function (d) {
      if (d && d.code == 1 && d.data) {
        that.datalist = d.data;
        that.itemtype = that.datalist[0].code;
        that.datalist[that.index].productList.forEach(r => {
          if (r) {
            that.productType.push(r);
          }
        });
      }
    })

  },
  methods: {
    handleSelect(key, keyPath) {
      console.log(key, keyPath);
      this.activeIndex = key;
      this.index = key;
      this.itemtype = this.datalist[this.index].code;
      this.productType = this.datalist[this.index].productList;
    },
    submitOrder(){
      var that = this;
      var params = {
        itemCode: this.form1.productType,
        tm: {
          /*"tmFormType": "3",*/
          name: this.form1.tmname,
          tmApplyNum: this.form1.applynum,
          /*"picUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2pica0acda56eb4e47b9b97854ded94fa1d7.jpg",
          "colorizedPicUrl": "",
          "selecttype": "自主选择",*/
          totalPublicExpense: this.product.publicExpense,
          totalTaxes: this.totalTaxes,
          totalSum: this.form1.price,
          totalDiscounts: this.totalDiscounts,
          totalServiceCharge: this.product.serviceCharge,
          totalProfitSum: this.totalProfitSum,
          /*"sveItemRateConfig":"7.00",
          "totalDiscountsRate":"0.00"   */
        },
        apply: {
          contacts: this.form2.customerName,
          mobile: this.form2.customerMobile,
          email: this.form2.customerEmail,
          notes: "",
        },
        /*itemtype:this.itemtype,------
        serviceCode:this.form1.productType,
        orderPrice:this.form1.price,
        tmName:this.form1.tmname,
        applyNum:this.form1.applynum,
        publicExpense:this.product.publicExpense,
        serviceCharge:this.product.serviceCharge,
        totalTaxes:this.totalTaxes,
        totalDiscounts:this.totalDiscounts,
        totalProfitSum:this.totalProfitSum,
        customerName:this.form2.customerName,
        customerMobile:this.form2.customerMobile,
        customerEmail:this.form2.customerEmail,*/
      };
      that.$refs.form1.validate(valid => {
        if (valid) {
          that.$refs.form2.validate(valid => {
            if (valid) {
              var flag = this.priceChange();
              if (flag) {
                console.log("--------true--------");
                this.$root.postReq("/web/orderCtl/createOtherOrder", params).then(function (d) {
                  console.log("---------submitOrder-------");
                  console.log(d);
                  if (d.code == 1) {
                    that.$root.pushx({
                      title: "订单支付",
                      name: "/orderpay",
                      params: { orderNum: d.data.code }
                    });
                  } else {
                    console.log(d.msg, "-------createOtherOrder---error----------");
                  }
                })
              } else {
                console.log("---------false---------");
                return;
              }
            }
          });
        }
      });
    },
    productTypeChange(){
      console.log(this.form1.productType);
      for (var i = 0; i < this.productType.length; i++) {
        if (this.productType[i].code == this.form1.productType) {
          this.product = this.productType[i];
        }
      }
    },
    priceChange(){
      var flag = true;
      var invoiceTaxRate = Number(this.product.rateConfig);
      var totalSum = Number(this.form1.price);
      var totalPublicExpense = Number(this.product.publicExpense);
      var totalDiscountsRate = Number(this.product.discountsRateConfig);
      var totalServiceCharge = Number(this.product.serviceCharge);
      var totalDiscounts = 0;
      var shui = 0;

      console.log(totalServiceCharge, "totalServiceCharge...........");
      console.log(totalPublicExpense, "totalPublicExpense...........");

      console.log(totalDiscountsRate, "totalDiscountsRate...........");

      var maxTotalDiscounts = (Number(totalServiceCharge) + Number(totalPublicExpense)) * Number(totalDiscountsRate) / 100;

      console.log(maxTotalDiscounts, "maxTotalDiscounts...........");
      console.log(invoiceTaxRate, "invoiceTaxRate...........");
      maxTotalDiscounts = maxTotalDiscounts.toFixed(2);
      shui = totalSum * Number(invoiceTaxRate) / 100;
      shui = Number(shui.toFixed(2));
      if (totalSum < Number(totalServiceCharge + totalPublicExpense - maxTotalDiscounts)) {
        this.$message.warning("输入的订单价格有误，价格必须大于" + Number(totalServiceCharge + totalPublicExpense - maxTotalDiscounts));
        flag = false;
      }
      var totalTaxes = totalSum - totalSum / (1 + invoiceTaxRate / 100);
      totalTaxes = totalTaxes.toFixed(2);
      if (Number(totalSum) < (Number(totalServiceCharge) + Number(totalPublicExpense))) {
        totalDiscounts = Number(totalServiceCharge) + Number(totalPublicExpense) - Number(totalSum);
        totalDiscounts = totalDiscounts.toFixed(2);
      }
      if (totalDiscounts < 0) {
        totalDiscounts = 0;
      }
      if (totalDiscounts > maxTotalDiscounts) {
        this.$message.warning("输入的订单价格有误，订单价格必须大于" + Number(totalServiceCharge + totalPublicExpense - maxTotalDiscounts));
        flag = false;
      }
      var totalProfitSum = Number(totalSum) - Number(totalPublicExpense);
      totalProfitSum = totalProfitSum.toFixed(2);
      this.totalDiscounts = totalDiscounts;
      this.totalTaxes = totalTaxes;
      this.totalProfitSum = totalProfitSum;
      return flag;
    }


  },
  computed: Vuex.mapState({

  }),
    vname: "gsb_agencyotherreg"
}
