{
    template:'${tmpl}',
    data:function(){
        return {
          sumparams:["total_worth"],
          cansum:false,
          multipleSelection: [],
          isSingleSelect:false,
          bizCode:"businesscompany",
        }
    },
    mounted:function(){

    },
    created:function(){
      if(this.codePath.split("/").indexOf("businesscompany")>=0){
        this.bizCode="businesscompany";
      }else if(this.codePath.split("/").indexOf("businesspool")>=0){
        this.bizCode="businesspool";
      }else{
        this.cansum=true;
        this.bizCode="mybusiness";
      }
    },
    methods:{
      formatTime(data){
        if(data){
          var d = new Date(data);
          var datetime=d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate();
          return datetime;
        }else{
          return "";
        }
        
      },
      btnvisbleMethod(row,btn){
        if(btn.key=="protect"){
          if(row.business_status=="bhz"){
            return false;
          }else{
            return true;
          }
        }
        return true;
      },
       onColFormater(row,column,cellvalue,index){
        if(column.property=="dispense_time"){
          if(row["dispense_time"]){
            var date = new Date(row["dispense_time"]);
            var time= date.toLocaleDateString();
       
            return time;
          }
          
        }
        if(column.property=="claim_time"){
          return this.formatTime(row["claim_time"]);
        }
        if(column.property=="tm_end_day_max"){
          var time= this.formatTime(row["tm_end_day_min"]);
          var time2 = this.formatTime(row["tm_end_day_max"]);
          time=time+"至"+time2;
          if(!time && !time2){
            return "";
          }
          return time;
        }
        if(column.property=="recovery_time"){
          var time= this.formatTime(row["claim_time"]);
          var time2 = this.formatTime(row["recovery_time"]);
          time=time+"至"+time2;
          if(!time && !time2){
            return "";
          }
          return time;
        }
         return cellvalue;
       },
       handleSelectionChange:function(val){
         this.multipleSelection = val;
         console.log(val);
       },
       toolbarclick(key, b, selectedRows){
         var that=this;
         console.log("selectedRows@@@@@@@@@@@@@@@@@@@@@@@@");
         console.log(b);
         console.log(selectedRows);
         if(key=="receivebusiness"){
            if(selectedRows.length<1){
              this.$message.warning("请选择至少一条数据");
              return;
            }
            var ids=[];
            var bus_type = selectedRows[0].tm_company_type || "";
            var amount = 0;
            for(var i=0;i<selectedRows.length;i++){
              if(selectedRows[i].tm_company_type){
                if(!bus_type){
                  bus_type=selectedRows[i].tm_company_type;
                }
                if(bus_type!=selectedRows[i].tm_company_type){
                  this.$message.warning("商机类型不一致，请重新选择");
                  return;
                }
              }
              if(selectedRows[i].id){
                ids.push(selectedRows[i].id);
              }
              amount=amount+Number(selectedRows[i].total_amount || 0);
            }
            this.$alert('<p style=\'text-align: center;margin:10px 0;\'>本次共认领 <span style=\'color:#ff7f27\'>'+selectedRows.length+'</span>个客户，共<span style=\'color:#ff7f27\'>'+amount+'</span>条商机。</p><p style=\'text-align: center;margin:10px 0;\'>认领后请及时处理商机喔，否则系统会自动收回。</p>', '认领商机', {
              dangerouslyUseHTMLString: true,
              confirmButtonText: '确定',
              callback: action => {
                console.log(action);
                if(action=="confirm"){
                  this.$root.postReq("/web/businesscompanyCtl/freeClaimOperation", { ids:ids, bus_type:bus_type}).then(function (d) {
                    console.log(d);
                    if (d && d.code == 1) {
                      that.$message.success("操作成功");
                      that.$refs.grid.fetchData();
                    } else {
                      that.$message.warning(d.msg);
                    }
                    that.$root.hideMask();
                  }).catch(function (e) {
                    console.log(e);
                    that.$root.hideMask();
                    that.$message.warning("操作失败");
                  });
                }
              }
            });
            
         }
    
       },
       onRowClick(row,key,e){
          if(key=="mydetail"){
            this.$root.pushx({
              title:"线索详情",
              name:"/businessdetail",
              params:{
                sourcecode:row.code,
                tm_company_type:row.tm_company_type,
                applicant_cn:row.applicant_cn
              }
            });
            return;
          }
          if(key=="mybusinessdetail"){
            this.$root.pushx({
              title:"商机详情",
              name:"/mybusinessdetail",
              params:{
                sourcecode:row.code
              }
            });
            return;
          }
          if(key=="protect"){
            var that=this;
            var code = row.code;
            var bus_type = row.tm_company_type;
            if(!code){
              this.$message.warning("商机code参数错误");
              return;
            }
            if(!bus_type){
              this.$message.warning("商机bus_type参数错误");
              return;
            }
            this.$root.postReq("/web/businesscompanyCtl/protectBus", { code_list:[code], bus_type:bus_type}).then(function (d) {
              console.log(d);
              if (d && d.code == 1) {
                that.$message.success("操作成功");
                that.$refs.grid.fetchData();
              } else {
                that.$message.warning(d.msg);
              }
              that.$root.hideMask();
            }).catch(function (e) {
              console.log(e);
              that.$root.hideMask();
              that.$message.warning("操作失败");
            });
          }
       },
        
    },
    computed: Vuex.mapState({
      count:state=>state.count,
      headStyle:function(){
        return {"background-color":"white"};
      }
    }),
    vname:"gsb_businesscompany"
}
