{
  template: '${tmpl}',
    data: function() {

      return {
        form: {
          companyname: "",
          servicetel: "",
          cooperationtel: "",
          address: "",
          picUrl: "",
          loginUrl: "",
          aboutus: "",
          wxQrCodeUrl: "",
          icpNum:"",
          icpCard:"",
          establishmentYear:"",
        },
        rules: {
          companyname: [
            { required: true, message: '企业名称不能为空', trigger: 'blur' }
          ],
          establishmentYear: [
            { required: true, message: '企业成立年份不能为空', trigger: 'blur' }
          ],
          servicetel: [
            { required: true, message: '客服电话不能为空', trigger: 'blur' }
          ],
          cooperationtel: [
            { required: true, message: '商务合作不能为空', trigger: 'blur' }
          ],
          address: [
            { required: true, message: '企业地址不能为空', trigger: 'blur' }
          ],
          icpNum: [
            { required: true, message: 'ICP备案号不能为空', trigger: 'blur' }
          ],
          icpCard: [
            { required: true, message: 'ICP备案证不能为空', trigger: 'blur' }
          ],
          picUrl: [
            { required: true, message: '请上传底部icon', trigger: 'blur' }
          ],
          wxQrCodeUrl: [
            { required: true, message: '请上传客服微信号图片', trigger: 'blur' }
          ],
        },
        d: {},
        action: "",
      }
    },
  mounted: function() {
    var that = this;
    this.$root.postReq("/web/uploadCtl/getOssConfig", "").then(function (d) {
      that.d["key"] = "key";
      that.d["Bucket"] = d.Bucket;
      that.d["OSSAccessKeyId"] = d.OSSAccessKeyId;
      that.d["Signature"] = d.Signature;
      that.d["policy"] = d.policy;
      that.d["success_action_status"] = d.success_action_status;
      that.action = d.url;
    });
    this.fetchCompanyInfo();
  },
  created: function() {

  },
  methods: {
    fetchCompanyInfo(){
      var that = this;
      this.$root.postReq("/web/footerinfoCtl/fetchCompanyInfo", obj).then(function (d) {
        if (d.status == 0) {
          that.form.companyname = d.data.companyName;
          that.form.servicetel = d.data.serviceTel;
          that.form.cooperationtel = d.data.cooperationTel;
          that.form.address = d.data.address;
          that.form.picUrl = d.data.picUrl;
          /* that.form.loginUrl=d.data.loginUrl;*/
          that.form.aboutus = d.data.aboutUs;
          that.form.wxQrCodeUrl = d.data.wxQrCodeUrl;
          that.form.icpNum = d.data.icpNum;
          that.form.icpCard = d.data.icpCard;
          that.form.establishmentYear = d.data.establishmentYear;
        }
      })
    },
    uploadsuccess(obj){
      this.form.picUrl = obj;
    },
    uploadsuccess2(obj){
      /*  this.form.loginUrl=obj;*/
    },
    uploadsuccess3(obj){
      this.form.wxQrCodeUrl = obj;
    },
    error(err){
      this.$message.warning(`上传失败，请重新上传`);
      console.log(err);
    },
    submit(){
      var obj = {
        companyname: this.form.companyname,
        servicetel: this.form.servicetel,
        cooperationtel: this.form.cooperationtel,
        address: this.form.address,
        picUrl: this.form.picUrl,
        /* loginUrl:this.form.loginUrl,*/
        aboutus: this.form.aboutus,
        wxQrCodeUrl: this.form.wxQrCodeUrl,
        icpNum: this.form.icpNum,
        icpCard:this.form.icpCard,
        establishmentYear:this.form.establishmentYear,
      };
      console.log(obj);
      var that = this;
      this.$refs.form.validate((valid) => {
        if (valid) {
          this.$root.postReq("/web/footerinfoCtl/createOrUpdate", obj).then(function (d) {
            if (d.status == 0) {
              that.$message.success("企业信息完善成功");
              location.reload();
            }
          })
        } else {
          console.log('error submit!!');
          return false;
        }
      })

    },
    reset(){
      this.form.companyname = "";
      this.form.servicetel = "";
      this.form.cooperationtel = "";
      this.form.address = "";
      this.form.picUrl = "";
      this.form.aboutus = "";
      this.form.wxQrCodeUrl = "";
      this.form.icpNum = "";
    }

  },
  computed: {

  },
  vname: "gsb-footerinfo"
}
