{
  template: '${tmpl}',
    data: function() {
      var mobileValidator = (rule, value, callback) => {
        var x = /((\d{11})|^((\d{7,8})|(\d{4}|\d{3})-(\d{7,8})|(\d{4}|\d{3})-(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1})|(\d{7,8})-(\d{4}|\d{3}|\d{2}|\d{1}))$)/g.test(value);
        if (!x) {
          callback(new Error('联系电话格式错误！'));
        } else {
          callback();
        }
      };
      var emailValidator = (rule, value, callback) => {
        var x = /^([a-zA-Z0-9._-])+@([a-zA-Z0-9_-])+(\.[a-zA-Z0-9_-])+/.test(value);
        if (!x) {
          callback(new Error('电子邮箱格式错误！'));
        } else {
          callback();
        }
      };
      return {
        order:{},
        icpcustomerinfo:{},
        apply: {
          name: "",
          code: "",
          customerType:"",
          customerName:"",
          credentialsType:"",
          legalRepresentativeCertificateNo: "",
          legalRepresentativeCertificatePic:"",
          businessLicensePic:"",
          mobile: "",
          email: "",
          applyAddr:"",
          contacts:"",
        },
        applyrules: {
          customerType: [
            { type: 'string', required: true, message: '请选择法人类型', trigger: 'change' }
          ],
          credentialsType: [
            { type: 'string', required: true, message: '请选择企业法定代表人证件类型', trigger: 'change' }
          ],
          name: [
            { required: true, message: '请输入公司/申请人名称' }
          ],
          code: [
            { required: true, message: '请输入信用代码' }
          ],
          customerName:[
            { required: true, message: '请输入企业法定代表人姓名' },
          ],
          legalRepresentativeCertificateNo: [
            { required: true, message: '请输入企业法定代表人证件号' },
          ],
          applyAddr: [
            { required: true, message: '请输入执照详细地址' }
          ],
          contacts:[
            { required: true, message: '请输入联系人' }
          ],
          mobile: [
            { required: true, message: '请输入联系电话' },
            { validator: mobileValidator, trigger: 'blur' }
          ],
          email: [
            { required: true, message: '请输入电子邮箱' },
            { validator: emailValidator, trigger: 'blur' }
          ],
          legalRepresentativeCertificatePic:[
            { required: true, message: '请上传证件扫描件' }
          ],
          businessLicensePic:[
            { required: true, message: '请上传营业执照扫描件' }
          ]
        },
        d: {},
        action: "",
        order: {},
        loading: false,
        loading1: false,
        loading2: false,
        loading3: false,
        toViewImgKey: null,
        toViewImgType: false,
        toViewImgSrc: null,
        itemCode:"CP201910231025EaQM0b",
        serviceitem:null,
        price:'未知',
        orderNum:null
      }
    },
  computed: Vuex.mapState({
    count: state => state.count,
    headStyle: function () {
      return { "background-color": "white" };
    }
  }),
  created: function() {
    var that = this;
    var orderNum =  "ICPO201910241108KSkT";/**this.$router.history.current.query.orderNum; */
    if (!orderNum) {
      this.$message.warning("订单号参数错误");
    }else{
      this.orderNum=orderNum;
    }
    this.getOrderDetail();
    var company = this.$root.currentCompany;
    if (company && company.companyType == "self") {
      this.company = company;
    } else {
      this.$root.getReq("/web/companyCtl/findById", { cid: 1 }).then(function (d) {
        if (d && d.status == 0 && d.data) {
          that.company = d.data
        }
      });
    }

  },
  mounted: function() {
    var that = this;
    that.toTop();
    this.$root.postReq("/web/uploadCtl/getOssConfig", "").then(function (d) {
      that.d["key"] = "key";
      that.d["Bucket"] = d.Bucket;
      that.d["OSSAccessKeyId"] = d.OSSAccessKeyId;
      that.d["Signature"] = d.Signature;
      that.d["policy"] = d.policy;
      that.d["success_action_status"] = d.success_action_status;
      that.action = d.url;
    });
  },
  methods: {
    pointsRuleColor(i) {
      if (i < parseInt(this.step)) {
        return 'color: #535353;'
      } else if (i == parseInt(this.step)) {
        return 'color: #FFFFFF;'
      } else if (i > parseInt(this.step)) {
        return 'color: #535353;'
      }
    },
    pointsRuleBackColor(i) {
      if (i < parseInt(this.step)) {
        return 'background: #D8EDFB;z-index: ' + Math.abs(i - 5)
      } else if (i == parseInt(this.step)) {
        return 'background: #0F8EE9;z-index: ' + Math.abs(i - 5)
      } else if (i > parseInt(this.step)) {
        return 'background: #EDEDED;z-index: ' + Math.abs(i - 5)
      }
    },
    toViewImg(src) {
      this.toViewImgSrc = src;
      this.toViewImgType = true
    },
    mouseOverDemo(v, k) {
      if (v == 99) {
        this.floatBoxDemo = true
      } else {
        if (k) {
          this.toViewImgKey = k
        } else {
          this.toViewImgKey = v
        }
      }
    },
    mouseLeaveDemo(v) {
      this.floatBoxDemo = false;
      this.toViewImgKey = null
    },
    error(err){
      this.$message.warning(`上传失败，请重新上传`);
      console.log(err);
    },
    uploadsuccess(obj){
      console.log(obj, "bbbbbbbbbbbbbbbbbbbbbbbbbbb");
      var that = this;
      if (this.loadingKey == 1) {
        that.loading1 = true;
      } else if (this.loadingKey == 2) {
        that.loading2 = true;
      } else if (this.loadingKey == 3) {
        that.loading3 = true;
      } else if (this.loadingKey == 0) {
        that.loading = true;
      }
      if (obj.flag == "yyzz") {
        that.apply["businessLicensePic"] = obj.result;
      }
      if (obj.flag == "zjsmj") {
        that.apply["legalRepresentativeCertificatePic"] = obj.result;
      }
    },
    beforeUpload(file){
      var that = this;
      var isSize = false;
      var img = new Image();
      var _URL = window.URL || window.webkitURL;
      img.onload = function () {
        if (img.width == img.height) {
          isSize = true;
          that.$refs.ys_upload.ifupload = true;
        } else {
          isSize = false;
          that.$message.warning('上传的图片宽高必须相等');
          that.$refs.ys_upload.$refs.upload.abort(file);
        }
      };
      img.src = window.URL.createObjectURL(file);

    },
    getOrderDetail: function() {
      var orderNum = this.orderNum;
      var that = this;
      this.$root.getReq("/web/orderCtl/getIcpOrderDetail", { orderNum: orderNum }).then(function (d) {
        if (d && d.code == 1) {
          that.order = d.data.order;
          var data = d.data;
          that.icpcustomerinfo = data.icpcustomerinfo;
          var apply={
            name: "",
            code: "",
            customerType:"",
            customerName:"",
            credentialsType:"",
            legalRepresentativeCertificateNo: "",
            legalRepresentativeCertificatePic:"",
            businessLicensePic:"",
            mobile: "",
            email: "",
            applyAddr:"",
            contacts:""
          };
          if(data.icpcustomerinfo){
            var ci = data.icpcustomerinfo;
            apply.name=ci.name;
            apply.code=ci.code;
            apply.customerType=ci.customerType;
            apply.customerName=ci.customerName;
            apply.credentialsType=ci.credentialsType;
            apply.legalRepresentativeCertificateNo=ci.legalRepresentativeCertificateNo;
            apply.legalRepresentativeCertificatePic=ci.legalRepresentativeCertificatePic;
            apply.businessLicensePic=ci.businessLicensePic;
            apply.applyAddr=ci.applyAddr;
          }
          if(data.order){
            apply.mobile=data.order.mobile;
            apply.email=data.order.email;
            apply.contacts = data.order.contacts;
          }
          that.apply=apply;
          if(data.order && data.order.serviceitem){
            that.serviceitem = data.serviceitem;
            that.price = data.serviceitem.price;
          }else{
            that.getServiceItem();
          }
          
        }else{
          that.$message.warning("获取订单失败");
        }
      }).catch(function (e) {
        that.$message.warning("获取订单操作失败");
      });
    },
    getServiceItem(){
      var itemCode = this.itemCode;
      var that = this;
      if (itemCode) {
        this.$root.getReq("/web/serviceitemCtl/findOneByCode", { code: itemCode }).then(function (d) {
          if (d && d.code == 1 && d.data.isPubed) {
            var data = d.data;
            that.serviceitem = data;
            that.price = data.price || '未知'
          } else {
            that.$message.warning(d.msg);
          }
        }).catch(function (e) {
          that.$message.warning("获取产品失败");
        })
      } else {
        this.$message.warning('code参数错误');
        return;
      }
    },
    submitForm() {
      var that = this;
      this.$refs["apply"].validate((valid) => {
        if (valid) {
          if(this.serviceitem && this.serviceitem.id){
            var icpobj = {itemCode:this.itemCode,apply:this.apply,price:this.price,orderNum:this.orderNum};
            if (!this.currentUser) {
              localStorage.setItem("afterLogin", JSON.stringify({
                title: "ICP注册",
                name: "/selficpreg",
                params: {apply: this.apply }
              }));
              this.$root.pushx({
                title: "登录",
                name: "/login"
              });
              return false;
            }
            that.$root.postReq("/web/orderCtl/updateIcpOrder", icpobj).then(function (d) {
              
              that.$root.hideMask();
            }).catch(function (e) {
              that.$message.warning("操作失败");
              that.$root.hideMask();
            });
          }else{
            that.$message.warning("未知产品");
            return false;
          }
        } else {
          console.log('error submit!!');
          return false;
        }
      });
    },
    applierChange(){
      this.$root.getReq("/web/toolCtl/getEntregistryByCompanyName", { companyName: this.apply.name }).then(d => {
        if (d.creditCode && d.creditCode != "") {
          this.apply.applyAddr = d.businessAddress;
          this.apply.code = d.creditCode;
        }
      });
    },
    setKey(name, flag){
      console.log("setKey+++++++++++++++++++++++++++");
      console.log(name);
      console.log(flag);
      name = name.substring(name.length - 5);
      var myDate = new Date();
      var key = "zc_" + flag + Math.round(Math.random() * 10000) + myDate.getTime() + myDate.getFullYear() + myDate.getMonth() + myDate.getDate() + ".jpg";

      this.$refs[flag].d.key = key;
    },
    toTop(){
      $('#app').animate({ scrollTop: 0 }, 10);
    },
  },

  vname: "gsb-icporderedit"
}
