{
  template: '${tmpl}',
    data: function() {
      return {
        emds: [],
        vcode: "",
        currentFrm: null,
        m: "130000_130100_130102",
      }
    },
  mounted: function() {
    this.emds = [
      {
        "title": "网站信息",
        "colnum": 3,
        "ctls": [
          { "type": "input", "label": "网站域名", "prop": "domainname", "placeHolder": "请输入网站域名地址", "style": "", rules: [{ "required": true, "message": '网站域名地址', "trigger": 'blur' },], },
          { "type": "input", "label": "站点名称", "prop": "sitename", "placeHolder": "请输入站点名称", "style": "", rules: [{ "required": true, "message": '站点名称', "trigger": 'blur' },] },
          { "type": "input", "label": "企业名称", "prop": "companyName", "placeHolder": "请输入企业名称", "style": "", rules: [{ "required": true, "message": '请输入企业名称', "trigger": 'blur' },] },
          { "type": "upload", "label": "logo", "prop": "logo", "placeHolder": "请上传logo", "style": "" },
        ]
      },
      {
        "title": "账号信息",
        "colnum": 3,
        "ctls": [
          { "type": "input", "label": "收款人", "prop": "payeeName", "placeHolder": "请输入收款人信息", "style": "", rules: [{ "required": true, "message": '请输入收款人信息', "trigger": 'blur' },] },
          { "type": "input", "label": "银行账号", "prop": "moneyaccountcode", "placeHolder": "请输入银行账号", "style": "", rules: [{ "required": true, "message": '请输入银行账号', "trigger": 'blur' },], },
          { "type": "input", "label": "开户行", "prop": "moneyaccountname", "placeHolder": "请输入开户行", "style": "", rules: [{ "required": true, "message": '请输入开户行', "trigger": 'blur' },] },
        ]
      },
      {
        "title": "管理员帐号信息",
        "ctls": [
          { "type": "input", "label": "用户名", "prop": "userName", "placeHolder": "请输入用户名", "style": "", rules: [{ "required": true, "message": '请输入用户名', "trigger": 'blur' },] },
          { "type": "password", "label": "密码", "prop": "password", "placeHolder": "请输入用户密码", "style": "", rules: [{ "required": true, "message": '请输入用户密码', "trigger": 'blur' },] },
          { "type": "password", "label": "确认密码", "prop": "cfmpwd", "placeHolder": "请输入确认密码", "style": "", rules: [{ "validator": "validatex", "trigger": 'blur' }, { "required": true, "message": '请输入确认密码', "trigger": 'blur' },] },

        ]
      },
      {
        "title": "联系方式",
        "ctls": [
          { "type": "input", "label": "联系人", "prop": "nickName", "placeHolder": "请输入联系人姓名", "style": "", rules: [{ "required": true, "message": '请输入企业名称', "trigger": 'blur' },] },
          { "type": "input", "label": "手机号", "prop": "mobile", "placeHolder": "请输入手机号", "style": "", rules: [{ "required": true, "message": '请输入手机号', "trigger": 'blur' },] },
          { "type": "btn", "label": "获取验证码", "prop": "vcodeget", "placeHolder": "请输入手机号", "style": { "margin-left": "8px" }, "face": "primary" },
          { "type": "input", "label": "验证码", "prop": "vcode", "placeHolder": "请输入收到的手机验证码", "style": "", rules: [{ "validator": "validatex", "trigger": 'blur' }, { "required": true, "message": '请输入验证码', "trigger": 'blur' },] },
          { "type": "input", "label": "客服QQ", "prop": "serviceqq", "placeHolder": "请输入客服QQ", "style": "" },
          { "type": "input", "label": "邮编", "prop": "zipCode", "placeHolder": "请输入邮编", "style": ""},
        ]
      },
    ];
    this.currentFrm = this.$refs.eapplyFrm;
    if (this.currentUser != null) {
      setTimeout(() => {
        this.$root.currentCompany.userName = this.currentUser.userName;
        this.$root.currentCompany.nickName = this.currentUser.nickName;
        this.$root.currentCompany.mobile = this.currentUser.mobile;
        this.$root.currentCompany.companyName = this.$root.currentCompany.name;
        this.$root.currentCompany.moneyaccountcode = this.$root.bankAccount.code;
        this.$root.currentCompany.moneyaccountname = this.$root.bankAccount.name;
        this.$root.currentCompany.moneyaccountid = this.$root.bankAccount.id;
        this.currentFrm.setInitData(this.$root.currentCompany);
      }, 100);

    }
  },
  created: function() {

  },
  methods: {
    ch: function() {
      console.log(this.m);
    },
    validmethod: function (rule, value, callback) {
      console.log("code validdate");
      var self = this;
      var fm = this.currentFrm.getFormModel();
      if (rule.field == "cfmpwd") {
        if (fm.password != value) {
          return callback(new Error("两次输入的密码不一致，请重新输入！"));
        }
      }
      if (rule.field == "vcode") {
        if (self.vcode != value) {
          return callback(new Error("验证码输入错误，请重新输入或重新获取后输入！"));
        }
      }
      return callback();
    },
    sbhandler: function () {
      var self = this;
      var fm = this.currentFrm.getFormModel();
      console.log(JSON.stringify(fm));
      this.currentFrm.validate(function (v) {
        if (v) {
          self.$root.postReq("/web/companyCtl/siteapply", { u: fm }).then(function (d) {
            if (d && d.status == 0) {
              self.$message({
                type: 'success',
                message: '网站开通申请已受理，平台服务人员会联系您，请耐心等待.'
              });
              location.reload();
            }
          });
        }
      });
    },
    updatehandler(){
      var self = this;
      var fm = this.currentFrm.getFormModel();
      this.currentFrm.validate(function (v) {
        if (v) {
          self.$root.postReq("/web/companyCtl/siteupdate", { u: fm }).then(function (d) {
            if (d && d.status == 0) {
              self.$message({
                type: 'success',
                message: '网站修改已受理，平台服务人员会联系您，请耐心等待.'
              });
              location.reload();
            }
          });
        }
      });
    },
    btnclick: function(pfm, code) {
      var fm = pfm;
      if (code == "vcodeget") {
        var that = this;
        if (/^1[23456789]\d{9}$/.test(fm.mobile) == false) {
          this.$alert('请输入正确格式的手机号码', '提示', {
            confirmButtonText: '确定',
            callback: action => {
            }
          });
          return;
        }
        this.$root.showMask();
        /*ajax 调用获取手机验证码,并存储到*/
        this.$root.postReq("/web/userCtl/fetchVcode", { mobile: fm.mobile }).then(function (d) {
          if (d.status == 0) {
            that.vcode = d.data.vcodestr;
            setTimeout(() => {
              that.$root.hideMask();
            }, 3000);
          }
        });
      }
    },
  },
  vname: "gsb_siteapply"
}
