{
  template:'${tmpl}',
  data:function(){
      return {
        active: 0,
        orderflowsteps:[
          {code:"1",name:"提交订单"},
          {code:"2",name:"已付款"},
          {code:"3",name:"已审核-待递交"},
          {code:"4",name:"已递交"},
          {code:"5",name:"已完成"},
        ],
        ncldata:[
          {code:"01",name:"化学原料"},{code:"02",name:"颜料油漆"},{code:"03",name:"日化用品"},{code:"04",name:"燃料油脂"},{code:"05",name:"医药"},
          {code:"06",name:"金属材料"},{code:"07",name:"机械设备"},{code:"08",name:"手工器械"},{code:"09",name:"科学仪器"},{code:"10",name:"医疗器械"},
          {code:"11",name:"灯具空调"},{code:"12",name:"运输工具"},{code:"13",name:"军火烟火"},{code:"14",name:"珠宝钟表"},{code:"15",name:"乐器"},
          {code:"16",name:"办公用品"},{code:"17",name:"橡胶制品"},{code:"18",name:"皮革皮具"},{code:"19",name:"建筑材料"},{code:"20",name:"家具"},
          {code:"21",name:"厨房洁具"},{code:"22",name:"绳网袋篷"},{code:"23",name:"纱线丝"},{code:"24",name:"布料床单"},{code:"25",name:"服装鞋帽"},
          {code:"26",name:"纽扣拉链"},{code:"27",name:"地毯席垫"},{code:"28",name:"健身器材"},{code:"29",name:"食品"},{code:"30",name:"方便食品"},
          {code:"31",name:"饲料种籽"},{code:"32",name:"啤酒饮料"},{code:"33",name:"酒"},{code:"34",name:"烟草烟具"},{code:"35",name:"广告销售"},
          {code:"36",name:"金融物管"},{code:"37",name:"建筑修理"},{code:"38",name:"通讯服务"},{code:"39",name:"运输贮藏"},{code:"40",name:"材料加工"},
          {code:"41",name:"教育娱乐"},{code:"42",name:"网站服务"},{code:"43",name:"餐饮住宿"},{code:"44",name:"医疗园艺"},{code:"45",name:"社会服务"}

        ],
        order:{},
        trademark:{},
        trademarks:[],
        customerinfo:{},
        tmstuffs:[],
        orderNum:"",
        orderflow:[],
        company:{},
        receiptvoucher:{},
        roleList:null,
        isBizemp:false,
      }
  },
  computed: Vuex.mapState({
    count:state=>state.count,
    headStyle:function(){
      return {"background-color":"white"};
    }
  }),
  created:function(){
    console.log("currentUser++++++++++++++++++++++++++++++");
    console.log(this.currentUser);
    var currentUser = this.currentUser;
    if(currentUser){
      var roles = currentUser.roles;
      if(roles){
        this.roleList=roles.split(",");
      }
    }
    if(this.roleList && this.roleList.length>0){
      for(var i=0;i<this.roleList.length;i++){
        if(this.roleList[i]=="bizemp"){
          this.isBizemp=true;
        }
      }
    }
    var orderNum=this.$router.history.current.query.orderNum;
    if(!orderNum){
      this.$message.warning("订单号参数错误");
      if(this.isBizemp){
        this.$root.pushx({
          title:"我的订单",
          name:"/myordermag"
        });
      }else{
        this.$root.pushx({
          title:"我的订单",
          name:"/myorder"
        });
      }
    }
    this.orderNum = orderNum;
    this.getOrderDetail();
  },
  mounted:function(){
      
  },
  methods:{
    getOrderDetail:function(){
      var orderNum = this.orderNum;
      var that=this;
      this.$root.showMask();
      this.$root.getReq("/web/orderCtl/getTmOrderDetail",{orderNum:orderNum}).then(function(d){
        console.log("/web/orderCtl/getTmOrderDetail");
        console.log(d);
        if(d && d.code=="1"){
          var d_tm = d.data.trademarks[0];
          var d_tms = d.data.trademarks;
          var d_order = d.data.order;
          var d_customer = d.data.customerinfo;
          var d_stuffs = d.data.tmstuffs;
          var d_orderflow = d.data.orderflow;
          that.company = d.data.company;
          if(d.data.receiptvoucher){
            if(d.data.receiptvoucher.payDate){
              d.data.receiptvoucher.payDate = that.formatTime(d.data.receiptvoucher.payDate);
            }
            that.receiptvoucher = d.data.receiptvoucher;
            console.log("that.receiptvoucher");
            console.log(that.receiptvoucher);
          }
          for(var j=0;j<d_stuffs.length;j++){
            var stuff = d_stuffs[j];
            if(stuff.stuffType=="ty"){
              d_tm["picUrl"]=stuff.stuffUrl;
            }
            if(stuff.stuffType=="csty"){
              d_tm["colorizedPicUrl"]=stuff.stuffUrl;
            }
            if(stuff.stuffType=="gzwts"){
              d_tm["sealAuthorizeStuff"]=stuff.stuffUrl;
            }
            if(stuff.stuffType=="smwj"){
              d_tm["descUrl"]=stuff.stuffUrl;
            }
          }
          that.active = d_order.orderFlowStatus?Number(d_order.orderFlowStatus):0;

          var order=d_order;
          for(var i=0;i<d_orderflow.length;i++){
            d_orderflow[i].created_at = that.formatTime(d_orderflow[i].created_at);
          }
          that.orderflow = d_orderflow;
          that.trademark = d_tm;
          that.customerinfo = d_customer;
          that.order=order;
          that.tmstuffs = d_stuffs;
          that.itemCode = order.sveItemCode;
          var trademarks=[];
          for(var i=0;i<d_tms.length;i++){
            var t = d_tms[i];
            var nclThree = JSON.parse(t.nclSmallCodes);
            var ncl_name = that.ncldata[Number(t.nclOneCodes)-1].name;
            var o={code:t.nclOneCodes,name:name,nclThree:nclThree};
            t["ncl"]=o;
            t["nclOneName"] = ncl_name;
            trademarks.push(t);
          }
          that.trademarks = trademarks;
          console.log("!!!!!!!!!!!!!!!!!!!!!!!");
          console.log(that.order);
          console.log(that.trademark);
          console.log(that.customerinfo);
          console.log(that.tmstuffs);
          console.log(that.trademarks);
        }
        that.$root.hideMask();
      }).catch(function(e){
        that.$root.hideMask();
      });
    },
    showUrl(url){
      window.open(url);
    },
    formatTime(data){
      if(data){
        var d = new Date(data);
        var datetime=d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate() + ' ' + d.getHours() + ':' + d.getMinutes() + ':' + d.getSeconds();
        return datetime;
      }else{
        return "";
      }
      
    }
  },

  vname:"gsb-tmOrderDetail"
}
