{
  template:'${tmpl}',
  data:function(){
     
      return {
        code:"",
        ncl_one_code:"",
        tmdetail:{},
        showneed:false,
        need:{

        },
        needrules:{
          buyer_quoted_price: [
            { required: true, message: '请输入您的报价'}
          ],
          buyer_name: [
            { required: true, message: '请输入您的称呼'}
          ],
          buyer_mobile: [
            { required: true, message: '请输入联系方式'}
          ],
        },
        option:{
            tooltip: {
                trigger: 'axis'
            },
            radar: [
                {
                    indicator: [
                        {text: '法律指数', max: 100},
                        {text: '市场效应', max: 100},
                        {text: '搜索热度', max: 100},
                        {text: '工商指数', max: 100},
                        {text: '易记度', max: 100}
                    ],
                    center: ['50%','30%'],
                    radius: 80
                }
            ],
            series: [
                {
                    type: 'radar',
                    tooltip: {
                        trigger: 'item'
                    },
                    itemStyle: {normal: {areaStyle: {type: 'default'}}},
                    data: []
                },
            ]
        }
      }
  },
  computed: Vuex.mapState({
    count:state=>state.count,
    headStyle:function(){
      return {"background-color":"white"};
    }
  }),
  created:function(){
    this.$root.isfront = true;
    this.$root.headerRowType = true;
  },
  mounted:function(){
    console.log("this.$router.history.current.query");
    console.log(this.$router.history.current.query);
    var code = this.$router.history.current.query.sbzch;
    var ncl_one_code = this.$router.history.current.query.gjfl;
    if(ncl_one_code){
      this.ncl_one_code=ncl_one_code;
    }else{
      this.$message.warning("gjfl参数错误");
      this.$root.pushx({
        title:"商标交易",
        name:"/tmtransactionmarket"
      });
      return;
    }
    if(code){
      this.code=code;
    }else{
      this.$message.warning("sbzch参数错误");
      this.$root.pushx({
        title:"商标交易",
        name:"/tmtransactionmarket"
      });
      return;
    }
    this.tmTransactionDetail();
  },
  methods:{
    tiaozhuan(path,name) {
      this.$root.pushx({
        title: name,
        name: path
      });
    },
    showTmNeed(){
      this.need={};
      this.showneed=true;
    },
    submitNeed(){
      this.$refs["needForm"].validate((valid) => {
        if (valid) {
          var needObj = this.need;
          console.log(needObj);
          needObj["code"] = this.code;
          this.$root.postReq("web/trademarktransactionneedCtl/submitNeed",needObj).then(d=>{
            console.log(d);
            if(d && d.code==1){
              this.$message.success("提交报价成功");
              this.showneed=false;
            }else{
              this.$message.warning(d.msg);
            }
          }).catch(e=>{
            this.$message.warning("操作失败");
          })
        } else {
          console.log('error submit!!');
          return false;
        }
      });
    },
    tmTransactionDetail(){
      if(this.ncl_one_code && this.code){
        this.$root.postReq("web/trademarktransactionCtl/tmTransactionDetail",{	"sbzch":this.code,"gjfl":this.ncl_one_code}).then(d=>{
          if(d && d.status==0 && d.data && d.data.detail){
            this.tmdetail=d.data.detail;
            var data1=this.$refs.echarts.getEchartObj();
            function sum (m,n){
            　var num = Math.floor(Math.random()*(m - n) + n);
              return num
            };
            var option = data1.getOption();
            option.series[0].data = [{ value: [sum(70,90),sum(30,70),sum(20,50),sum(30,60),sum(20,80)], name: this.tmdetail.sbmc }];
            data1.setOption(option);
          }
        }).catch(e=>{
          this.$message.warning("操作失败");
        })
      }else{
        this.$message.warning("参数错误");
        this.$root.pushx({
          title:"商标交易",
          name:"/tmtransactionmarket"
        });
        return;
      }

    },
  },

  vname:"gsb-tmtransactiondetail"
}
