const system = require("../system");
const moment = require('moment');
const settings = require("../../config/settings");

class ConsumerBase {
  constructor(className) {
    this.serviceName = className;
    this.execClient = system.getObject("util.execClient");
    this.pushSuccessLogDao = system.getObject("db.opLogs.pushSuccessLogDao");
    this.pushFailureLogDao = system.getObject("db.opLogs.pushFailureLogDao");
    this.errorLogDao = system.getObject("db.opLogs.errorLogDao");
    this.redisClient = system.getObject("util.redisClient");
    this.duplicateInstance = this.redisClient.getDuplicateInstance();
  }
  static getServiceName(ClassObj) {
    return ClassObj["name"];
  }
  async doConsumer(queuedName, counter) {
    try {
      if (!counter) {
        counter = 1;
      }
      var self = this;
      this.duplicateInstance.brpop(queuedName, 0, async function (err, repl) {
        if (err) {
          return new Error('doConsumer brpop error :' + err);
        }
        else {
          if (repl[1]) {
            self.execSubDoConsumer(queuedName, JSON.parse(repl[1]));
          }
          self.doConsumer(queuedName, counter);
        }
      });
    } catch (error) {
      this.errorLogDao.addOpErrorLogs("队列执行doConsumer存在异常", null, null, error.stack, 3);
      //日志
      console.log(error.stack, "，队列执行doConsumer存在异常");
    }
  }

  async execSubDoConsumer(queuedName, actionBody) {
    var execResult = null;
    try {
      this.subBeforeConsumer(queuedName, actionBody);
      actionBody.requestId = await this.getBusUid("PUB-");
      if (queuedName.indexOf("SYTXFAIL-SYTXPUBLIC-MSGQ") < 0) {
        execResult = await this.subDoConsumer(queuedName, actionBody);
        actionBody.resultInfo = execResult;
        if (execResult.status === 1) {
          var notifyQueuedName = "NOTIFY-SYTXPUBLIC-MSGQ";
          if (queuedName.indexOf(notifyQueuedName) < 0) {
            if (actionBody.notifyUrl && actionBody.notifyUrl.indexOf("http") >= 0) {
              await this.redisClient.lpushData(notifyQueuedName, actionBody);
            }
          }
          if ("LOGS-SYTXPUBLIC-MSGQ" != settings.queuedName) {
            await this.pushSuccessLogDao.addOpSuccessLogs("推送成功", actionBody, execResult);
          }
          return;
        }
        var failQueuedName = "SYTXFAIL-SYTXPUBLIC-MSGQ";
        actionBody.queuedName = queuedName;
        actionBody.counter = actionBody.counter ? actionBody.counter : 1;
        await this.redisClient.lpushData(failQueuedName, actionBody);
        return;
      }
      if (actionBody.counter > 4) {
        await this.pushFailureLogDao.addOpFailureLogs("推送失败", actionBody, actionBody.resultInfo);
        return;
      }
      execResult = await this.subDoConsumer(queuedName, actionBody);
    } catch (error) {
      this.errorLogDao.addOpErrorLogs("队列执行execSubDoConsumer存在异常", actionBody, execResult, error.stack, 3);
      //日志记录
      console.log(error.stack, "，队列执行execSubDoConsumer存在异常");
    }
  }


  async subBeforeConsumer(queuedName, actionBody) {
    console.log("请在子类中重写此方法进行前置操作......", this.serviceName);
  }
  async subDoConsumer(queuedName, actionBody) {
    throw new Error("请在子类中重写此方法进行操作业务逻辑............................!");
  }
  sleep(milliSeconds) {
    var startTime = new Date().getTime();
    while (new Date().getTime() < startTime + milliSeconds);
  }
  /**
 * 带超时时间的post请求
 * @param {*} params 请求数据-json格式
 * @param {*} url 请求地址
 * @param {*} ContentType 请求头类型，默认application/json
 * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
 */
  async execPostByTimeOut(params, url, ContentType, headData, timeOut = 60) {
    return await this.execClient.execPostTimeOutByBusiness("consumer.base", params, url, ContentType, headData, timeOut);
  }
  /*
 返回20位业务订单号
 prefix：业务前缀
 */
  async getBusUid(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 8 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    var timStr = moment().format("YYYYMMDDHHmm");
    return prefix + timStr + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }
}
module.exports = ConsumerBase;
