const ConsumerBase = require("../../consumer.base");
const system = require("../../../system");
const moment = require('moment');

class PublicFailConsumer extends ConsumerBase {
  constructor() {
    super(ConsumerBase.getServiceName(PublicFailConsumer));
  }
  async subBeforeConsumer(queuedName, actionBody) {
    console.log("前置操作......", this.serviceName);
  }
  async subDoConsumer(queuedName, actionBody) {
    actionBody.counter = actionBody.counter + 1;
    var exTime = actionBody.counter * 20;
    var mathStr = await this.getUidInfo(3, 10);
    var scoreValue = Number(moment().format("YYYYMMDDHHmmssSSS") + mathStr);

    await this.redisClient.init(scoreValue);
    await this.redisClient.setDelayEventData(queuedName, scoreValue, exTime);
    await this.redisClient.zaddSortedSet(queuedName, scoreValue, actionBody);
    return system.getResultSuccess();
  }
}
module.exports = PublicFailConsumer;