const ConsumerBase = require("../../consumer.base");
const system = require("../../../system");

class PublicLogsConsumer extends ConsumerBase {
  constructor() {
    super(ConsumerBase.getServiceName(PublicLogsConsumer));
    this.configInfoDao = system.getObject("db.opLogs.configInfoDao");
    this.errorLogDao = system.getObject("db.opLogs.errorLogDao");
    this.esUtils = system.getObject("util.esUtils");
  }
  async subBeforeConsumer(queuedName, actionBody) {
    console.log("前置操作......", this.serviceName);
  }
  async subDoConsumer(queuedName, actionBody) {
    var params = {
      opTitle: actionBody.opTitle,
      identifyCode: actionBody.identifyCode,
      messageBody: actionBody.messageBody,
      requestId: actionBody.requestId
    }
    var execResult = await this.esUtils.addEsLogs(queuedName, actionBody);;
    return execResult;
  }
}
module.exports = PublicLogsConsumer;