const system = require("../system");
class Dao {
  constructor(modelName) {
    this.modelName = modelName;
    var db = system.getObject("db.common.connection").getCon();
    this.db = db;
    this.model = db.models[this.modelName];
  }
  static getModelName(ClassObj) {
    var nameStr = ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Dao"));
    var initialStr = nameStr.substring(0, 1);
    var resultStr = initialStr.toLowerCase() + nameStr.substring(1, nameStr.length);
    return resultStr;
  }
  preCreate(u) {
    return u;
  }
  /**
   * 
   * @param {*} u 对象
   * @param {*} t 事务对象t
   */
  async create(u, t) {
    var u2 = this.preCreate(u);
    if (t) {
      return this.model.create(u2, { transaction: t }).then(u => {
        return u;
      });
    } else {
      return this.model.create(u2, { transaction: t }).then(u => {
        return u;
      });
    }
  }
  async customQuery(sql, paras, t) {
    var tmpParas = null;//||paras=='undefined'?{type: this.db.QueryTypes.SELECT }:{ replacements: paras, type: this.db.QueryTypes.SELECT };
    if (t && t != 'undefined') {
      if (paras == null || paras == 'undefined') {
        tmpParas = { type: this.db.QueryTypes.SELECT };
        tmpParas.transaction = t;
      } else {
        tmpParas = { replacements: paras, type: this.db.QueryTypes.SELECT };
        tmpParas.transaction = t;
      }
    } else {
      tmpParas = paras == null || paras == 'undefined' || paras.keys == 0 ? { type: this.db.QueryTypes.SELECT } : { replacements: paras, type: this.db.QueryTypes.SELECT };
    }
    var result = this.db.query(sql, tmpParas);
    return result;
  }
}
module.exports = Dao;
