const system = require("../../../system");
const AppServiceBase = require("../../app.base");
const settings = require("../../../../config/settings");
const moment = require('moment');
//用户权限操作
class UtilsIcService extends AppServiceBase {
  constructor() {
    super();
    this.esUtils = system.getObject("util.esUtils");
  }
  /**
     * 接口跳转-POST请求
     * action_type     执行的类型
     * action_body     执行的参数
     */
  async getListByLikeCompanyName(actionBody) {
    if (!actionBody.companyName) {
      return system.getResult(null, "查询的公司名称不能为空");
    }
    actionBody.companyName = await this.getConvertSemiangleStr(actionBody.companyName);
    var pageSize = !actionBody.pageSize ? 15 : Number(actionBody.pageSize);
    if (pageSize < 0) {
      pageSize = 15;
    }
    var from = !actionBody.currentPage ? 0 : Number((actionBody.currentPage - 1) * pageSize);
    if (from < 0) {
      from = 0;
    }

    var esIndexName = "tx_ic_bigdata_business_index/_search";
    var params = {
      "query": {
        "bool": {
          "must": [
            {
              "query_string": {
                "default_field": "company_name",
                "query": '\"' + actionBody.companyName + '\"'
              }
            }
          ]
        }
      },
      "from": from,
      "size": pageSize,
      "_source": [
        "company_name",//公司名称
        "company_org_type",//公司类型
        "credit_code",//统一社会信用代码
        "legal_person",//法人姓名
        "from_time",//营业期限开始日期
        "to_time",//营业期限结束日期
        "estiblish_time",//成立时间
        "reg_status",//公司状态
        "reg_number",//注册号
        "org_number",//组织机构代码
        "reg_location",//公司地址
        "reg_capital",//注册资本
        "business_scope",//公司经营范围
        "reg_institute",//登记机关
        "company_province",//公司省份
        "company_city",//公司二级市
        "company_cate_1",//行业分类一级分类
        "company_cate_2",//行业分类二级分类
        "company_cate_3"//行业分类三级分类
      ]
      // ,
      // "sort": [
      //   {
      //     "reg_capital": "desc"
      //   }
      // ]
    }


    var resultData = null;
    try {
      resultData = await this.esUtils.execPostEs(settings.queuedName, params, esIndexName);
      var sources = [];
      var data = {
        "totalCount": resultData.data.hits.total,
        "pageSize": pageSize,
        "currentPage": actionBody.currentPage - 1,
        "list": sources
      };
      if (!resultData.data.hits) {
        return system.getResultSuccess();
      }
      if (!resultData.data.hits.hits) {
        return system.getResultSuccess();
      }
      resultData.data.hits.hits.forEach(function (c) {
        if (c._source.estibish_time != null) {
          var time = new Date(c._source.estibish_time * 1000);
          c._source.estibish_time = time.toLocaleDateString();
        }
        var source = {
          "companyName": c._source.company_name,//公司名称
          "companyOrgType": c._source.company_org_type || "",//公司类型
          "creditCode": c._source.credit_code || "",//统一社会信用代码
          "legalPerson": c._source.legal_person,//法人姓名
          "fromTime": c._source.from_time ? moment(c._source.from_time * 1000).format("YYYY-MM-DD") : "",//营业期限开始日期
          "toTime": c._source.to_time ? moment(c._source.to_time * 1000).format("YYYY-MM-DD") : "",//营业期限结束日期
          "estiblishTime": c._source.estiblish_time ? moment(c._source.estiblish_time * 1000).format("YYYY-MM-DD") : "",//成立时间
          "regStatus": c._source.reg_status || "",//公司状态
          "regNumber": c._source.reg_number || "",//注册号
          "orgNumber": c._source.org_number || "",//组织机构代码
          "regLocation": c._source.reg_location || "",//公司地址
          "regCapital": c._source.reg_capital || "",//注册资本
          "businessScope": c._source.business_scope || "",//公司经营范围
          "regInstitute": c._source.reg_institute || "",//登记机关
          "companyProvince": c._source.company_province || "",//公司省份
          "companyCity": c._source.company_city || "",//公司二级市
          "companyCate1": c._source.company_cate_1 || "",//行业分类一级分类
          "companyCate2": c._source.company_cate_2 || "",//行业分类二级分类
          "companyCate3": c._source.company_cate_3 || ""//行业分类三级分类	

        };
        sources.push(source);
      });
      // j.hits.hits = data;
      return system.getResultSuccess(data);
    } catch (e) {
      return { status: -1, msg: "操作失败", data: null };
    }
  }
  async getConvertSemiangleStr(str) {
    var result = "";
    str = str.replace(/\s+/g, "");
    var len = str.length;
    for (var i = 0; i < len; i++) {
      var cCode = str.charCodeAt(i);
      //全角与半角相差（除空格外）：65248（十进制）
      cCode = (cCode >= 0xFF01 && cCode <= 0xFF5E) ? (cCode - 65248) : cCode;
      //处理空格
      cCode = (cCode == 0x03000) ? 0x0020 : cCode;
      result += String.fromCharCode(cCode);
    }
    return result;
  }
}
module.exports = UtilsIcService;
