const system = require("../system");
const moment = require('moment')
// const settings = require("../../config/settings");
class ServiceBase {
  constructor(gname, daoName) {
    this.execClient = system.getObject("util.execClient");
    this.db = system.getObject("db.common.connection").getCon();
    this.daoName = daoName;
    this.dao = system.getObject("db." + gname + "." + daoName);
  }
  static getDaoName(ClassObj) {
    var nameStr = ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Service")) + "Dao";
    var initialStr = nameStr.substring(0, 1);
    var resultStr = initialStr.toLowerCase() + nameStr.substring(1, nameStr.length);
    return resultStr;
  }
  /**
      * 带超时时间的post请求
      * @param {*} params 请求数据-json格式
      * @param {*} url 请求地址
      * @param {*} ContentType 请求头类型，默认application/json
      * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
      */
  async execPostByTimeOut(params, url, ContentType, headData, timeOut = 60) {
    return await this.execClient.execPostTimeOutByBusiness("sve.base", params, url, ContentType, headData, timeOut);
  }
  async create(qobj) {
    return this.dao.create(qobj);
  }
  async customQuery(sql, paras, t) {
    return this.dao.customQuery(sql, paras, t);
  }
  /*
  返回20位业务订单号
  prefix：业务前缀
  */
  async getBusUid(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 8 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    var timStr = moment().format("YYYYMMDDHHmm");
    return prefix + timStr + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }
}
module.exports = ServiceBase;
