﻿var url = require("url");
var system = require("../../base/system");
module.exports = function (app) {
	//-----------------------新的模式---------api---------开始

	app.all("/api/*", async function (req, res, next) {
		if (req.path === "/api/uploadAction/txCos/getCosInfo") {
			next();
			return;
		}
		var result = system.getResult(null, "req method must is post");
		if (req.method != "POST") {
			res.end(JSON.stringify(result));
			return;
		}
		if (!req.body.actionType) {
			result.msg = "actionType can not be empty";
			res.end(JSON.stringify(result));
			return;
		}
		next();
	});

	app.get('/api/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];

		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);
		req.clientIp = tClientIp;
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		var params = [];
		params.push(gname);
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexecMethod"]) {
			p = invokeObj["doexecMethod"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});
	app.post('/api/:gname/:qname/:method', function (req, res) {
		var classPath = req.params["qname"];
		var methodName = req.params["method"];
		var gname = req.params["gname"];
		var params = [];
		classPath = gname + "." + classPath;
		var tClientIp = system.get_client_ip(req);

		req.clientIp = tClientIp;
		req.uagent = req.headers["user-agent"];
		req.classname = classPath;

		params.push(gname);
		params.push(methodName);
		params.push(req.body);
		params.push(req.query);
		params.push(req);
		var p = null;
		var invokeObj = system.getObject("api." + classPath);
		if (invokeObj["doexecMethod"]) {
			p = invokeObj["doexecMethod"].apply(invokeObj, params);
		}
		p.then(r => {
			res.end(JSON.stringify(r));
		});
	});

	//-----------------------新的模式---------api---------结束
};
