var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");

var cacheBaseComp = null;

class BusinessmenCtl extends CtlBase {
  constructor() {
    super();
    this.businessmenSve = system.getObject("service.business.businessmenSve");

  }

  async allPage(pobj, pobj2, req) {
    try {
      let condition = {
        currentPage: pobj.currentPage,
        pageSize: pobj.pageSize,
        order_id: this.trim(pobj.order_id),
        deliver_id: this.trim(pobj.deliver_id),
        name: this.trim(pobj.name),
        legal_name: this.trim(pobj.legal_name),
        legal_mobile: this.trim(pobj.legal_mobile),
        legal_idcard: this.trim(pobj.legal_idcard),
        credit_code: this.trim(pobj.credit_code)
      };
      if (!condition.deliver_id) {
        return system.getResult(null, "请重新登录");
      }
      return await this.businessmenSve.allPage(condition);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async myPage(pobj, pobj2, req) {
    try {
      let condition = {
        currentPage: pobj.currentPage,
        pageSize: pobj.pageSize,
        order_id: this.trim(pobj.order_id),
        name: this.trim(pobj.name),
        operator_id: this.trim(req.loginUser.id),
        legal_name: this.trim(pobj.legal_name),
        legal_mobile: this.trim(pobj.legal_mobile),
        legal_idcard: this.trim(pobj.legal_idcard),
        credit_code: this.trim(pobj.credit_code)
      };
      if (!condition.operator_id) {
        return system.getResult(null, "请重新登录");
      }
      return await this.businessmenSve.allPage(condition);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

}

module.exports = BusinessmenCtl;