var system = require("../../../system")
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");
const uuidv4 = require('uuid/v4');
var moment = require("moment");
var svgCaptcha = require('svg-captcha');

class DeliverCtl extends CtlBase {
  constructor() {
    super();
    this.deliverSve = system.getObject("service.common.deliverSve");
  }

  async all(pobj, pobj2, req) {
    try {
      return await this.deliverSve.all(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async page(pobj, pobj2, req) {
    try {
      return await this.deliverSve.page(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async info(pobj, pobj2, req) {
    try {
      return await this.deliverSve.info(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async save(pobj, pobj2, req) {
    try {
      return await this.deliverSve.save(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async del(pobj, pobj2, req) {
    try {
      return await this.deliverSve.del(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async deliverUserPage(pobj, pobj2, req) {
    try {
      return await this.deliverSve.deliverUserPage(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async deliverUserById(pobj, pobj2, req) {
    try {
      return await this.deliverSve.deliverUserById(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async deliverUserSave(pobj, pobj2, req) {
    try {
      return await this.deliverSve.deliverUserSave(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  } 

  async allOrg(pobj, pobj2, req) {
    try {
      return await this.deliverSve.allOrg(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async orgTree(pobj, pobj2, req) {
    try {
      return await this.deliverSve.orgTree(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async orgById(pobj, pobj2, req) {
    try {
      return await this.deliverSve.orgById(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
  async orgSave(pobj, pobj2, req) {
    try {
      return await this.deliverSve.orgSave(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }


  async provinceList(pobj, pobj2, req) {
    try {
      return system.getResultSuccess([
        {"id": 1100, "name":"北京市"},
        {"id": 1200, "name":"天津市"},
        {"id": 1300, "name":"河北省"},
        {"id": 1400, "name":"山西省"},
        {"id": 1500, "name":"内蒙古自治区"},
        {"id": 2100, "name":"辽宁省"},
        {"id": 2200, "name":"吉林省"},
        {"id": 2300, "name":"黑龙江省"},
        {"id": 3100, "name":"上海市"},
        {"id": 3200, "name":"江苏省"},
        {"id": 3300, "name":"浙江省"},
        {"id": 3400, "name":"安徽省"},
        {"id": 3500, "name":"福建省"},
        {"id": 3600, "name":"江西省"},
        {"id": 3700, "name":"山东省"},
        {"id": 4100, "name":"河南省"},
        {"id": 4200, "name":"湖北省"},
        {"id": 4300, "name":"湖南省"},
        {"id": 4400, "name":"广东省"},
        {"id": 4500, "name":"广西壮族自治区"},
        {"id": 5000, "name":"重庆市"},
        {"id": 5100, "name":"四川省"},
        {"id": 5200, "name":"贵州省"},
        {"id": 5300, "name":"云南省"},
        {"id": 5400, "name":"西藏自治区"},
        {"id": 6100, "name":"陕西省"},
        {"id": 6200, "name":"甘肃省"},
        {"id": 6300, "name":"青海省"},
        {"id": 6400, "name":"宁夏回族自治区"},
        {"id": 6500, "name":"新疆维吾尔自治区"},
        {"id": 7100, "name":"台湾省"},
        {"id": 8100, "name":"香港特别行政区"},
        {"id": 8200, "name":"澳门特别行政区"},
      ]);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

}
module.exports = DeliverCtl;