var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class InvoiceCtl extends CtlBase {
  constructor() {
    super();
    this.invoiceSve = system.getObject("service.invoice.invoiceSve");
    this.pageType = {
      "0": ["2020", "2030"],    // 我的业务发票
      "1": ["2010"],          // 发票办理
    };
  }

  getPageStatus(type) {
    type = this.trim(type || "0");
    return this.pageType[type];
  }

  /**
   * 业务进度字典
   * @param {*} pobj 
   */
  async processDics(pobj, pobj2, req) {
    try {
      return await this.invoiceSve.processDics(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 发票申请列表-管理员
   * @param {*} pobj 
   */
  async invoicePage(pobj, pobj2, req) {
    try {
      this.doTimeCondition(pobj, ["createTimeBegin", "createTimeEnd"]);
      return await this.invoiceSve.invoicePage(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  setRoleAuth(pobj, loginUser) {
    if (loginUser.isManager) {
      // 暂时先什么都不做
    } else
      if (loginUser.isMain) {
      if (!loginUser.org_path) {
        return system.getResultSuccess({count: 0, rows: []});
      }
      pobj.operator_path_like = loginUser.org_path + "%";
    } else {
      pobj.operator_id = loginUser.id || 0;
    }
  }

  /**
   * 发票申请列表-业务员
   * @param {*} pobj 
   */
  async myInvoicePage(pobj, pobj2, req) {
    try {
      pobj.assigned = true;
      // 获取页面类型状态
      pobj.statuses = this.getPageStatus(pobj.pageType);
      // 设置角色参数
      this.setRoleAuth(pobj, req.loginUser);

      this.doTimeCondition(pobj, ["createTimeBegin", "createTimeEnd"]);
      return await this.invoiceSve.invoicePage(pobj);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 进度处理
   * @param {*} pobj 
   */
  async handleStatus(pobj) {
    try {
      return await this.invoiceSve.handleStatus(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 根据ID查详细信息
   * @param {*} pobj 
   */
  async invoice(pobj, pobj2, req) {
    try {
      return await this.invoiceSve.invoice(pobj); 
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

  /**
   * 发票申请
   * @param {*} pobj
   */
  async invoiceApply(pobj, pobj2, req) {
    try {
      pobj.invoice_amount = system.y2f(pobj.invoice_amount);
      pobj.additional_tax = system.y2f(pobj.additional_tax);
      pobj.value_added_tax = system.y2f(pobj.value_added_tax);
      pobj.personal_invoice_tax = system.y2f(pobj.personal_invoice_tax);
      pobj.invoice_content = system.y2f(pobj.invoice_content);

      return await this.invoiceSve.invoiceApply(pobj);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, `接口错误 错误信息 ${error}`);
    }
  }

}
module.exports = InvoiceCtl;