var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");
const logCtl = system.getObject("web.common.oplogCtl");

var cacheBaseComp = null;
class MerchantsignedCtl extends CtlBase {
  constructor() {
    super();
    this.merchantsignedSve = system.getObject("service.merchant.merchantsignedSve");
  }

  async page(pobj, pobj2, req) {
    try {
      var condition = {
        currentPage: pobj.currentPage,
        pageSize: pobj.pageSize,
        merchantId: pobj.merchantId || pobj.merchant_id,
      }
      return await this.merchantsignedSve.page(condition);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async save(pobj, pobj2, req) {
    try {
      var sign = {};

      sign.id = pobj.id;
      sign.merchantId = this.trim(pobj.merchantId) || this.trim(pobj.merchant_id);
      sign.nameA = this.trim(pobj.nameA);
      sign.contractNo = this.trim(pobj.contractNo);
      sign.beginDate = this.trim(pobj.beginDate);
      sign.endDate = this.trim(pobj.endDate);
      sign.serviceRate = this.trim(pobj.serviceRate);

      return await this.merchantsignedSve.save(sign);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

  async info(pobj, pobj2, req) {
    try {      
      return await this.merchantsignedSve.info(pobj);
    } catch (error) {
      console.log(error);
      return system.getResultFail(500, "接口异常：" + error.message);
    }
  }

}
module.exports = MerchantsignedCtl;