var system = require("../../../system")
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");
var cacheBaseComp = null;
class MerchanttitleCtl extends CtlBase {
  constructor() {
    super();
    this.merchanttitleSve = system.getObject("service.merchant.merchanttitleSve");
  }
  
  async merchantTitleList(params){
    params.currentPage=params.currentPage || 1;
    params.pageSize=params.pageSize || 10;
    try {
      let res = await this.merchanttitleSve.merchantTitleList(params);
      return res;
    } catch (error) {
      return system.getResultFail(500, "接口错误");
    }
  }

  async merchantTitleSave(params){
    try {
      console.log(params);
      return await this.merchanttitleSve.merchantTitleSave(params);
    } catch (error) {
      return system.getResultFail(500, "接口错误");
    }
  }
  async merchantTitleInfo(params){
    try {
      console.log(params);
      return await this.merchanttitleSve.merchantTitleInfo(params);
    } catch (error) {
      return system.getResultFail(500, "接口错误");
    }
  }

  async merchantTitleDefault(params){
    if(!params.id){
      return system.getResultFail();
    }else{
      try {
        return await this.merchanttitleSve.merchantTitleDefault(params);
      } catch (error) {
        return system.getResultFail(500, "接口错误");
      }
    }
  }

}
module.exports = MerchanttitleCtl;