var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class AuthCtl extends CtlBase {
  constructor() {
    super();
    this.authSve = system.getObject("service.uc.authSve");
  }

  /**
   * 菜单  添加 
   * @param {*} params 
   */
  async addAuth(params, pobj2, req) {
    params.saas_id = req.loginUser.saas_id;
    try {
      var auth = {
        pid: Number(params.pid || 0),
        saas_id: params.saas_id,
        menuType: Number(params.menuType || 0),
        name: this.trim(params.name),
        icon: this.trim(params.icon),
        path: this.trim(params.path),
        sort: 99,
      };
      return await this.authSve.addAuth(auth);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 菜单  更新
   * @param {*} params 
   */
  async updAuth(params, pobj2, req) {
    params.saas_id = req.loginUser.saas_id;
    var auth = {
      id: Number(params.id),
      pid: Number(params.pid || 0),
      saas_id: params.saas_id,
      menuType: Number(params.menuType || 0),
      name: this.trim(params.name),
      icon: this.trim(params.icon),
      path: this.trim(params.path),
    };

    try {
      return await this.authSve.updAuth(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 菜单 删除 
   * @param {*} params 
   */
  async delAuth(params, pobj2, req) {
    params.saas_id = req.loginUser.saas_id;

    try {
      return await this.authSve.delAuth(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 菜单  查询明细
   * @param {*} params 
   */
  async queryById(params, pobj2, req) {
    params.saas_id = req.loginUser.saas_id;

    try {
      return await this.authSve.queryById(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 根据pid查出子目录
   * @param {*} params 
   */
  async byPid(params, pobj2, req) {
    params.saas_id = req.loginUser.saas_id;

    try {
      return await this.authSve.byPid(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 查询整个树结构
   * @param {*} params 
   */
  async tree(params, pobj2, req) {
    params.saas_id = req.loginUser.saas_id;

    try {
      return await this.authSve.tree(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

}
module.exports = AuthCtl;