const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings")

class BusinessmenService extends ServiceBase {
  constructor() {
    super();
  }

  async byOrderId(params) {
    let rs = await this.callms("order", "businessmenByOrderId", params);
    this.transField([rs.data]);
    return rs;
  }

  async allPage(params) {
    let rs = await this.callms("order", "businessmenPage", params);
    if (rs.status != 0 || !rs.data || !rs.data.rows) {
      return rs;
    }
    this.transField(rs.data.rows);
    return rs;
  }


  transField(rows) {
    if (!rows) {
      return;
    }

    for (var row of rows) {
      row.costRate = system.f2y(row.costRate);
      row.taxRate = system.f2y(row.taxRate);
      row.serviceRate = system.f2y(row.serviceRate);
      row.serviceBeginTime = system.f2y(row.serviceRate);
      row.serviceRate = system.f2y(row.serviceRate);
      this.handleDate(row, ["service_begin_time", "service_end_time", "tax_reg_day", "reg_date", "sign_time"], "YYYY-MM-DD", -8);
      this.parseJsonField(row, ["common_tax_ladder", "common_other_ladder", "special_tax_ladder", "special_other_ladder"]);
    }
  }

  parseJsonField(row, fields) {
    if (!row || !fields || fields.length == 0) {
      return;
    }
    for (var f of fields) {
      if (!f) {
        continue;
      }
      if (!row[f]) {
        row[f] = [];
        continue;
      }
      try {
        row[f] = JSON.parse(row[f]);
      } catch (error) {
        console.log(error);
      }
    }
  }

  //
  // async signPage(params) {
  //   var rs = await this.callms("order", "businessmenSignPage", params);
  //   if (rs.status != 0 || !rs.data || !rs.data.rows) {
  //     return rs;
  //   }
  //   this.transField(rs.data.rows);
  //   return rs;
  // }
  //
  // async deliverPage(params) {
  //   var rs = await this.callms("order", "businessmenDeliverPage", params);
  //   if (rs.status != 0 || !rs.data || !rs.data.rows) {
  //     return rs;
  //   }
  //   this.transField(rs.data.rows);
  //   return rs;
  // }
  //
  // async info(params) {
  //   var rs = await this.callms("order", "businessmenInfo", params);
  //   await this.setMerchant([rs.data]);
  //   this.transField([rs.data]);
  //   return rs;
  // }
  //
  // async sign(params) {
  //   return await this.callms("order", "businessmenSign", params);
  // }
  //
  // async nameList(params) {
  //   return await this.callms("order", "businessmenNameList", params);
  // }
  //
  // async queryBusinessmen(params) {
  //   var condition = {
  //     merchantId: this.trim(params.merchant_id || params.merchantId),
  //     channelOrderNo: this.trim(params.channelOrderNo),
  //   }
  //   var rs = await this.callms("order", "businessmenByChannelOrderNo", condition);
  //   if (rs.status != 0 && !rs.data) {
  //     return rs;
  //   }
  //   var businessmen = rs.data;
  //   if(!businessmen) {
  //     return system.getResult(null, "个体户不存在");
  //   }
  //   var dto = {};
  //
  //   dto.orderNo = this.trim(businessmen.orderNo);
  //   dto.channelOrderNo = this.trim(businessmen.channelOrderNo);
  //   dto.status = this.trim(businessmen.gstatus);
  //   dto.legalName = this.trim(businessmen.legalName);
  //   dto.legalMobile = this.trim(businessmen.legalMobile);
  //   dto.legalIdCard = this.trim(businessmen.legalIdCard);
  //   dto.name = this.trim(businessmen.name);
  //   dto.creditCode = this.trim(businessmen.creditCode);
  //   dto.businessPlace = this.trim(businessmen.businessPlace);
  //   dto.businessScope = this.trim(businessmen.businessScope);
  //   dto.regDate = this.trim(businessmen.regDate);
  //   dto.businessImg = this.trim(businessmen.businessImg);
  //   dto.gongzhang = this.trim(businessmen.gongzhang);
  //   dto.caiwuzhang = this.trim(businessmen.caiwuzhang);
  //   dto.fapiaozhang = this.trim(businessmen.fapiaozhang);
  //   dto.hetongzhang = this.trim(businessmen.hetongzhang);
  //   dto.farenzhang = this.trim(businessmen.farenzhang);
  //   dto.isBank = businessmen.isBank ? 1 : 0;
  //   dto.bankName = this.trim(businessmen.bankName);
  //   dto.bankNo = this.trim(businessmen.bankNo);
  //   dto.bank = this.trim(businessmen.bank);
  //   dto.bankImg = this.trim(businessmen.bankImg);
  //   dto.caImg = this.trim(businessmen.caImg);
  //   dto.taxRegDay = this.trim(businessmen.taxRegDay);
  //   dto.taxOrg = this.trim(businessmen.taxOrg);
  //   dto.courierNo = this.trim(businessmen.courierNo);
  //   dto.courierImg = this.trim(businessmen.courierImg);
  //   dto.addedValueRate = this.trim(businessmen.addedValueRate);
  //   dto.supertaxRate = this.trim(businessmen.supertaxRate);
  //   dto.commonTaxLadder = this.trim(businessmen.commonTaxLadder);
  //   dto.commonOtherLadder = this.trim(businessmen.commonOtherLadder);
  //   dto.specialTaxLadder = this.trim(businessmen.specialTaxLadder);
  //   dto.specialOtherLadder = this.trim(businessmen.specialOtherLadder);
  //   dto.contractStartData = this.trim(businessmen.contractStartData);
  //   dto.contractEndData = this.trim(businessmen.contractEndData);
  //   dto.contract = this.trim(businessmen.contract);
  //   dto.opNotes = this.trim(businessmen.opNotes);
  //   dto.taxUpType = this.trim(businessmen.taxUpType);
  //   dto.costRate = this.trim(businessmen.costRate);
  //   dto.signNotes = this.trim(businessmen.signNotes);
  //   dto.invoiceContents = this.trim(businessmen.invoiceContents);
  //   return system.getResultSuccess(dto);
  // }
  //
  // async putContract(params) {
  //   var merchantId = params.merchant_id || params.merchantId;
  //
  //   var condition = {
  //     merchantId: merchantId,
  //     channelOrderNo: params.channelOrderNo,
  //     contractStartData: params.contractStartData,
  //     contractEndData: params.contractEndData,
  //     contract: params.contract,
  //   };
  //   var rs = await this.callms("order", "addBusinessmenContract", condition);
  //   return rs;
  // }
  //
  // async setMerchant(rows) {
  //   if (!rows || rows.length == 0) {
  //     return;
  //   }
  //
  //   var merchantIds = [];
  //   for (var row of rows) {
  //     merchantIds.push(row.merchant_id);
  //   }
  //
  //   var mmap = await this.callms("merchant", "getMapByIds", {
  //     ids: merchantIds,
  //     attrs: "id, name"
  //   });
  //   mmap = mmap.data || {};
  //   for (var row of rows) {
  //     row.merchant = mmap[row.merchant_id] || {};
  //   }
  // }

}

module.exports = BusinessmenService;
// var task=new UserService();
// task.getUserStatisticGroupByApp().then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });