const system = require("../../../system");
const ServiceBase = require("../../svems.base");
var settings = require("../../../../config/settings");

class CaptchaService extends ServiceBase {
  constructor() {
    super();
  }

  async captcha(params) {
    // "width": 120,                   // 验证码图片宽度 默认 120px
    // "height": 36,                   // 验证码图片高度 默认 36px
    // "background": "",               // 验证码图片背景色，默认 #E8E8E8
    // "expire": 0                     // 验证码过期时间（秒）
    var result = {};
    var capthaData = await this.callms("common", "getCaptha", params);

    if(capthaData.status === 0) {
      result.key = capthaData.data.key;
      result.captcha = capthaData.data.captcha;
      console.log(result.key + " : " + result.text);
      return system.getResultSuccess(result);
    }
    return system.getResult(null, "获取图片验证码失败");
  }

  async valid(params) {
    var result = {};
    return await this.callms("common", "validCaptha", params);
  }
}
module.exports = CaptchaService;
