const system = require("../../../system");
const ServiceBase = require("../../svems.base")
const settings = require("../../../../config/settings")
class OrderService extends ServiceBase {
  constructor() {
    super();
    this.pushapiSve = system.getObject("service.push.pushapiSve");
    this.deliverSve = system.getObject("service.common.deliverSve");
  }

  async allProcess(params) {
    try {
      return await this.callms("order", "allProcess", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async orders(params) {
    var rs = await this.callms("order", "orderDelivers", params);
    if (rs.status === 0 && rs.data) {
      await this.setUcUser(rs.data.rows);
      await this.transfields(rs.data.rows);
    }
    return rs;
  }

  async handleStatus(params) {
    return await this.callms("order", "handleStatus", params);
  }

  async orderInfo(params) {
    var rs = await this.callms("order", "orderInfo", params);
    return rs;
  }

  async orderAndDeliver(params) {
    var rs = await this.callms("order", "orderAndDeliver", params);
    return rs;
  }

  async orderInfoAll(params) {
    let rs = await this.callms("order", "orderInfoAll", params);
    // await this.setUcUser([rs.data.order]);
    if (rs.status === 0 && rs.data) {
      if (rs.data.orderDeliver) {
        await this.setUcUser([rs.data.orderDeliver]);
      }
    }
    return rs;
  }

  async productDics(params) {
    var rs = await this.callms("order", "productDics", params);
    return rs;
  }

  async transfields(rows) {
    if (!rows || rows.length == 0) {
      return;
    }

    for (let row of rows) {
      if(row.deliver_divide) {
        row.deliver_divide = system.f2y(row.deliver_divide);
      }
    }
  }
  async setDeliverOperatorUser(rows) {
    if (!rows || rows.length == 0) {
      return;
    }

    let ids = [];
    for (let row of rows) {
      if (row.odeliver && row.odeliver.operator_id) {
        ids.push(row.odeliver.operator_id);
      }
    }

    let map = await this.deliverSve.mayByIds(ids);
    for (let row of rows) {
      let user = map[row.odeliver.operator_id] || {};
      row.odeliver.operator_name = user.real_name || "";
    }
  }

  async setUcUser(rows) {
    if (!rows || rows.length == 0) {
      return;
    }

    let ids = [];
    for (let row of rows) {
      if (row.operator_id) {
        ids.push(row.operator_id);
      }
    }

    let map = await this.deliverSve.mayByIds(ids);
    for (let row of rows) {
      let user = map[row.operator_id] || {};
      row.operator_name = user.real_name || "";
    }
  }

  // 交付商统计
  async deliverStatTransData(params) {
    if (!params.current_date) {
      return system.getResult(null, `参数错误 当前时间不能为空`);
    }
    if (!params.deliver_id) {
      return system.getResult(null, `参数错误 交付商不能为空`);
    }
    try {
      return await this.callms("order", "deliverStatTransData", params);
    } catch (error) {
      console.log(error);
      return system.getResult(null,`系统错误 错误信息 ${error}`);
    }
  }

  // 业务办理
  async businessManagement(params) {
    if (!params.current_date) {
      return system.getResult(null, `参数错误 当前时间不能为空`);
    }
    if (!params.deliver_id) {
      return system.getResult(null, `参数错误 交付商不能为空`);
    }
    try {
      return await this.callms("order", "businessManagement", params);
    } catch (error) {
      console.log(error);
      return system.getResult(null,`系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 更新个体户信息
   * @param {*} params 
   */
  async updateOBusinessmenProinvce(params) {
    var rs = await this.callms("order", "updateOBusinessmenProinvce", params);
    return rs;
  }


  /*********************************************以下是阿里的接口****************************************************************/
  /**
   * 添加订单
   * @param params
   * @returns {Promise<{msg: string, data: (*|null), bizmsg: string, status: number}|{msg: string, data, bizmsg: *|string, status: number}|*|undefined>}
   */
  async addSourceOrder(params) {
    try {
      return await this.callms("order", "addSourceOrder", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async aliOrderPageAll(params){
    try {
      let rs = await this.callms("order", "aliOrderPageAll", params);
      if (rs.status === 0 && rs.data) {
        await this.setDeliverOperatorUser(rs.data.rows);
      }
      return rs;
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async aliOrderPage(params){
    try {
      let rs = await this.callms("order", "aliOrderPage", params);
      if (rs.status === 0 && rs.data) {
        await this.setDeliverOperatorUser(rs.data.rows);
      }
      return rs;
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


}
module.exports = OrderService;