const system = require("../../../system");
const ServiceBase = require("../../svems.base")
class authService extends ServiceBase {
  constructor() {
    super();
  }

  /**
   * 菜单  添加 
   * @param {*} params 
   */
  async addAuth(params) {
    try {
      return await this.callms("uc", "addAuth", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 菜单  更新
   * @param {*} params 
   */
  async updAuth(params) {
    try {
      return await this.callms("uc", "updAuth", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 菜单 删除 
   * @param {*} params 
   */
  async delAuth(params) {
    try {
      return await this.callms("uc", "delAuth", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 菜单  查询明细
   * @param {*} params 
   */
  async queryById(params) {
    try {
      return await this.callms("uc", "authInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 根据pid查出子菜单
   * @param {*} params 
   */
  async byPid(params) {
    try {
      return await this.callms("uc", "authByPid", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 查询整个树结构
   * @param {*} params 
   */
  async tree(params) {
    try {
      return await this.callms("uc", "authTree", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

}
module.exports = authService;