const system = require("../../../system");
const ServiceBase = require("../../svems.base")

class UserService extends ServiceBase {
  constructor() {
    super();
    this.platformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.opuserrelationDao = system.getObject("db.common.opuserrelationDao");
  }

  async login(params) {
    try {
      return await this.callms("uc", "login", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   *   添加
   * @param {*} params
   */
  async addUser(params) {
    try {

      var relation = await this.opuserrelationDao.findOne({
        ucname: params.ucname
      });
      if (!relation) {
        var rs = await this.platformUtils.createUserInfo(params.ucname, params.ucname, params.password);
        if (!rs.data || !rs.data.account_id) {
          return rs;
        }
        params.ucid = rs.data.account_id;
        this.opuserrelationDao.model.create({
          ucname: params.ucname,
          ucid: rs.data.account_id,
        });
      } else {
        params.ucid = relation.ucid;
      }
      system.getResultSuccess();
      return await this.callms("uc", "addUser", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   *   更新
   * @param {*} params
   */
  async updUser(params) {
    try {
      return await this.callms("uc", "updUser", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async enabled(params) {
    try {
      return await this.callms("uc", "enabled", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * @param {*} params
   */
  async page(params) {
    try {
      return await this.callms("uc", "userPage", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   *  删除
   * @param {*} params
   */
  async delUser(params) {
    try {
      return await this.callms("uc", "delUser", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   *   查询明细
   * @param {*} params
   */
  async queryById(params) {
    try {
      return await this.callms("uc", "userInfo", params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * 修改密码
   * @param {*} params
   */
  async updPassword(params) {
    try {
      var user = await this.callms("uc", "userInfo", params);
      user = user.data;
      var rs = await this.platformUtils.modifyPassword(user.ucid, params.password);
      if (rs.status !== 0) {
        return rs;
      }
      await this.callms("uc", "updPassword", params);
      return system.getResultSuccess();
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }


  async mapByIds(params) {
    try {
      return await this.callms("uc", "mapUserByIds", params);
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  async salesmanList(params) {
    try {
      let rs = await this.callms("common", "deliverUserAll", params);
      return rs;
    } catch (error) {
      console.log(error);
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}

module.exports = UserService;