<a name="menu">目录</a>
1. [发票状态](#status)

1. [验证发票是否符合申请](#verification)已经弃用

1. [发票查询明细（平台）](#queryInvoice)
1. [发票查询明细（交付商）](#queryInvoiceDeliverer)

1. [发票试算](#calcInvoice) 已经弃用
1. [发票申请](#invoices)
1. [发票验证&试算](#verificationAndCalculation)
1. [计算增值税](#calculationValueAddedTax)
1. [发票附加税](#calculationAdditionalTax)
1. [发票申请列表（平台）](#queryInvoices)
1. [交付查看商审批列表](#delivererInvoices)

1. [发票平台审批](#platformAssignment)
1. [发票交付商审批](#delivererAssignment)
1. [完成税证明](#txPayment)
1. [查看完成税证明](#queryTxPayment)
1. [平台更新邮寄地址](#apiUpEmNO)




## **<a name="saveInvoice"> 发票状态</a>**　　　　　
[返回到目录](#menu)　　　　
```
{
	  "0090": {
                "status": "0090",
                "name": "未付款",
                "next": "1000",
                "cstatus": "0090",//客户
                "dstatus": "",//交付商
            },
            "1000": {
                "status": "1000",
                "name": "待审核",
                "next": "1020",
                "cstatus": "0090",//客户
                "dstatus": "",//交付商
            },
            "1010": {
                "status": "1010",
                "name": "审核不通过",
                "next": "",
                "cstatus": "1010",
                "dstatus": "",
            },
            "1020": {
                "status": "1020",
                "name": "待分配",
                "next": "1030",
                "cstatus": "1030",
                "dstatus": "",
            },
            "1030": {
                "status": "1030",
                "name": "待处理",
                "next": "1050",
                "cstatus": "1030",
                "dstatus": "1030",
            },
            "1040": {
                "status": "1040",
                "name": "交付商关闭",
                "next": "1020",
                "cstatus": "1030",
                "dstatus": "1040",
            },
            "1050": {
                "status": "1050",
                "name": "已开具",
                "next": "1060",
                "cstatus": "1050",
                "dstatus": "1050",
            },
            "1060": {
                "status": "1060",
                "name": "待审核",
                "next": "1070",
                "cstatus": "1050",
                "dstatus": "1070",
            },
            "1070": {
                "status": "1070",
                "name": "审核通过",
                "next": "1080",
                "cstatus": "1050",
                "dstatus": "1070",
            },
            "1080": {
                "status": "1080",
                "name": "已邮寄",
                "next": "1090",
                "cstatus": "1050",
                "dstatus": "1080",
            },
            "1090": {
                "status": "1090",
                "name": "完成",
                "next": "1100",
                "cstatus": "1090",
                "dstatus": "1080",
            },
            "1100": {
                "status": "1090",
                "name": "发票撤回",
                "next": "1100",
                "cstatus": "1090",
                "dstatus": "1080",
            },
            "1200": {
                "status": "1200",
                "name": "红冲",
                "next": "",
                "cstatus": "1200",
                "dstatus": "",
            },
            "1300": {
                "status": "1300",
                "name": "审核失败(平台第二次审核)",
                "next": "1060",
                "cstatus": "1050",
                "dstatus": "1060",
            }
}

```
## **<a name="verification"> 验证发票是否符合申请</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** '/web/invoice/invoiceCtl/verification'  
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| businessmenCreditCode| string | 是 | 　| 发票ID |

**示例**
```
{
	"businessmenCreditCode": "91210200MA0QE7GT5L"
}
```


**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**
```
{
    "code":200,
    "msg":"ok",
    "data":[

    ],
    "status":0,
    "requestid":"06336188128143c09c935e536c9742f2"
}

```



## **<a name="calcInvoice"> 发票试算</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/calcInvoice
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| businessmenCreditCode | string| 是 | 　| 销售方社会统一信用代码 |
| serviceRate | number| 是 | 　| 服务费率 |
| perCalWay | number| 是 | 　| 个税计算方式  1:年  请填写 1 |
| valCalWay | number| 是 | 　| 增值税计算方式 1:月 2:季度   |
| merchantId | string | 是 | 　| 商户id  |
| taxIncPriRat | number| 是 | 　| 不含税价百分比  |
| taxCostPriRat | number| 是 | 　| 核定成本费用率 |
| invoiceTime | String| 是 | 　| 开票时间 |
| invoiceAmount | number| 是 | 　| 发票金额 |
| perIncTaxRange | JSON | 是 | 　| 个税税额范围 |
| valAddTaxRange | JSON | 是 | 　| 增值税范围 |

**示例**

```
{
   "businessmenCreditCode": "111",
    "serviceRate": 225,
    "perCalWay": "1",
    "valCalWay": "1",
    "businessmenId": "12795594625000138",
    "taxCostPriRat": 1122,
    "taxIncPriRat": 1022,
    "invoiceTime": "2019-09-19",
    "invoiceAmount": 20000000,
    "perIncTaxRange": [
        {
            "minValue": 0,
            "rate": "0",
            "quiCalDed": 100000,
            "maxValue": 3000000
        },
        {
            "minValue": 3000100,
            "rate": "1.5",
            "quiCalDed": 200000,
            "maxValue": 10000000
        },
        {
            "minValue": 10000001,
            "rate": "4.86",
            "quiCalDed": 300000,
            "maxValue": 214748364700
        }
    ],
    "valAddTaxRange": [
        {
            "minValue": 0,
            "zengzhiRate": "0",
            "fujiaRate": "0",
            "maxValue": 3000000
        },
        {
            "minValue": 3000100,
            "zengzhiRate": "0",
            "fujiaRate": "0",
            "maxValue": 10000000
        },
        {
            "minValue": 10000001,
            "zengzhiRate": "3",
            "fujiaRate": "12",
            "maxValue": 214748364700
        }
    ]
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |


## **<a name="saveInvoice"> 发票申请保存</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/saveInvoice
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|

| serviceRate | number| 是 | 　| 服务费率 |
| perCalWay | number| 是 | 　| 个税计算方式  1:月 2：季度 3：年 |
| valCalWay | number| 是 | 　| 增值税计算方式 1:月 2:季度 3：年  |
| taxIncPriRat | number| 是 | 　| 不含税价百分比  |
| taxCostPriRat | number| 是 | 　| 核定成本费用率 |
| invoiceTime | String| 是 | 　| 开票时间 |
| perIncTaxRange | JSON | 是 | 　| 个税税额范围 |
| valAddTaxRange | JSON | 是 | 　| 增值税范围 |

| merchantId | string | 是 | 　| 商户id  |
| merchantAccount | string | 是 | 　| 商户账户  |
| merchantName | string | 是 | 　| 商户名称  |
| merchantCreditCode | string | 是 | 　| 商户社会统一信用代码  |
| merchantAddr | string | 是 | 　| 商户地址  |
| merchantMobile | string | 是 | 　| 商户电话  |
| merchantBank | string | 是 | 　| 商户开户行  |

| businessmenId | string| 是 | 　| 销售方ID |
| businessmenCreditCode | string| 是 | 　| 销售方社会统一信用代码 |
| businessmenType | number| 是 | 　| 销售方类型 10 个体工商 20 自然人 |
| businessName | string| 是 | 　| 销售方名称 |
| isBank | string| 是 | 　| 是否开户 1：开户 0：未开户 |

| invoiceNo | string | 否 | 　| 发票编号 |
| ruleCode | number| 是 | 　| 算法编码 10 个体工商 20 自然人算法 |
| type | number| 否 | 　| 发票类型  10 普通发票 20 增值税专用发票 30 电子发票 |
| invoiceAmount | number| 是 | 　| 发票金额 |
| statements | string | 是 | 　| 结算单子 |
| contract | string| 是 | 　| 合同 |

| applyNo | String| 是 | 　| 申请编号 |
| invoiceContent | string| 否 | 　| 开票内容 |
| applyMobile | string| 否 | 　| 申请电话 |
| isInvalid | string| 是 |  2　| 是否红冲    2 未红冲 |
| parentId | string| 否 | 　| 发票关联ID 红冲时添加此字段 |
| status | string| 否 | 1000　|平台 开票状态 默认 1000 |
| customerStatus | string| 否 | 1000　| 客户开票状态 默认 1000 |
| payWay | string| 是 | 　| 付款方式 10 系统账户扣款 20 线上支付 |
| payAccount | string| 是 |  | 付款账户 |
| isPay | number| 否 | 0　| 是否支付 调用前请再次确认此是否支付 |
| mailAddr | string| 是 |  | 邮寄地址 |
| mailMobile | string| 是 |  | 邮寄电话 |
| mailTo | string| 是 |  | 邮寄人 |

```
{
	
		"serviceRate": 400,
	    "perCalWay": "1",
	    "valCalWay": "2",
	    "taxCostPriRat": 1122,
	    "taxIncPriRat": 1022,
	    "invoiceTime": "2019-10-19",
	    "perIncTaxRange": [
	        {
	            "minValue": 0,
	            "rate": "1",
	            "quiCalDed": 100000,
	            "maxValue": 3000000
	        },
	        {
	            "minValue": 3000100,
	            "rate": "1.5",
	            "quiCalDed": 200000,
	            "maxValue": 10000000
	        },
	        {
	            "minValue": 10000001,
	            "rate": "4.86",
	            "quiCalDed": 300000,
	            "maxValue": 214748364700
	        }
	    ],
	    "valAddTaxRange": [
	        {
	            "minValue": 0,
	            "zengzhiRate": "1",
	            "fujiaRate": "6",
	            "maxValue": 3000000
	        },
	        {
	            "minValue": 3000100,
	            "zengzhiRate": "2",
	            "fujiaRate": "8",
	            "maxValue": 10000000
	        },
	        {
	            "minValue": 10000001,
	            "zengzhiRate": "3",
	            "fujiaRate": "12",
	            "maxValue": 214748364700
	        }
	    ],
	    "merchantId":"11064622752480055",
	    "merchantAccount":"driverBabyPublicAccount",
	    "merchantName": "司机宝",
	    "merchantCreditCode":"91110108MA008KB56P",
	    "merchantAddr":"北京市海淀区北太平庄路18号3层3-0227",
	    "merchantMobile":"010-5369854",
	    "merchantBank":"110108022130868",
	    "businessmenType":"10",
	    "businessmenId": "110115023996882",
	    "businessmenCreditCode": "91110115MA00HDC44L",
	    "businessName":"北京富通勤国际贸易有限责任公司（个体工商）",
	    "isBank":1,
	    "taxAuthorities":"北京大兴税务局",
	    "type":20,
	    "ruleCode":"10",
        "invoiceAmount": 40000000,
	    "statements":"wwww.baidu.com",
	    "contract":"www.qq.com",
	    "applyNo":"gongsibao-futong001",
	    "isInvalid":2,
	    "parentId":null,
	    "status":"1000",
	    "customerStatus":"1000",
	    "payWay":"20",
	    "payAccount":null,
	    "isPay":1,
	    "mailAddr":"北京市海淀区北太平庄路18号3层3-0227",
	    "mailMobile":"18633923636",
	    "mailTo":"赵彩红"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"ea903ff378d4469a8fef10a6e15f5036"
}
```

## **<a name="verificationAndCalculation"> 发票验证&试算</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/verificationAndCalculation
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| businessmenType | number| 是 | 　| 销售方类型 10 个体工商 20 自然人 |
| businessmenCreditCode | string| 是 | 　| 销售方社会统一信用代码 |
| ruleCode | number| 是 | 　| 算法编码 10 个体工商 20 自然人算法 |
| serviceRate | number| 是 | 　| 服务费率 例子：10.11% |
| perCalWay | number| 是 | 　| 个税计算方式  1:年  请填写 1 |
| valCalWay | number| 是 | 　| 增值税计算方式 1:月 2:季度   |
| merchantId | string | 是 | 　| 商户id  |
| taxIncPriRat | number| 是 | 　| 不含税价百分比  例子：10.11%|
| taxCostPriRat | number| 是 | 　| 核定成本费用率 例子：10.11%|
| invoiceTime | String| 是 | 　| 开票时间 |
| invoiceAmount | number| 是 | 　| 发票金额 |
| perIncTaxRange | JSON | 是 | 　| 个税税额范围 |
| valAddTaxRange | JSON | 是 | 　| 增值税范围 |

**示例**

```
{
   "businessmenCreditCode": "111",
    "serviceRate": 2.25,
    "perCalWay": "1",
    "valCalWay": "1",
    "businessmenId": "12795594625000138",
    "taxCostPriRat": 11.22,
    "taxIncPriRat": 10.22,
    "invoiceTime": "2019-09-19",
    "invoiceAmount": 2000000,
    "perIncTaxRange": [
        {
            "minValue": 0,
            "rate": "0",
            "quiCalDed": 100000,
            "maxValue": 3000000
        },
        {
            "minValue": 3000100,
            "rate": "1.5",
            "quiCalDed": 200000,
            "maxValue": 10000000
        },
        {
            "minValue": 10000001,
            "rate": "4.86",
            "quiCalDed": 300000,
            "maxValue": 214748364700
        }
    ],
    "valAddTaxRange": [
        {
            "minValue": 0,
            "zengzhiRate": "0",
            "fujiaRate": "0",
            "maxValue": 3000000
        },
        {
            "minValue": 3000100,
            "zengzhiRate": "0",
            "fujiaRate": "0",
            "maxValue": 10000000
        },
        {
            "minValue": 10000001,
            "zengzhiRate": "3",
            "fujiaRate": "12",
            "maxValue": 214748364700
        }
    ]
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |



## **<a name="calculationValueAddedTax"> 计算增值税</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/calculationValueAddedTax
**参数验证** 否     
**参数**    
``` javascript

//  字段描述    是否必填    默认值/注释
{
    "businessmenCreditCode": "111",          //销售方统一社会信用代码     是  
    "businessmenType":"10",                  //销售方类型               是        10：个体工商户   20：自然人 
    "calNames":"valueAddedTax",              //计算类型                 是        valueAddedTax:增值税
    "valCalWay": "1",                        //计算时间类型              是        1：月 2：季度 3：年
    "businessmenId": "12795594625000138",    //销售方ID                 是
    "taxIncPriRat": 0.03,                    //不含税价百分比             是        如果3% 请填写 0.03 此字段不能大于1
    "invoiceTime": "2019-11-26",             //发票时间                  是
    "invoiceAmount": 20000000,               //发票金额 单位：分          是
    "valAddTaxRange": [                      //增值税范围                是
        {
            "minValue": 0,                   //最小值 单位：分            是
            "zengzhiRate": "3",              //增值税百分比               是        如果3%请填写 3
            "fujiaRate": "12",               //附加税     否
            "maxValue": 3000000              //最大值 单位：分             是
        }
    ]
}
```

#### 返回结果
```javascript

{
    "status": 0,
    "msg": "操作成功",
    "data": "776699.03",           //增值税 单位：分
    "bizmsg": "empty",
    "requestid": "c19a411e7b5e41a48eb8b4a2d99a2987"
}

```

## **<a name="calculationAdditionalTax"> 计算附加税</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/calculationAdditionalTax
**参数验证** 否     
**参数**    

``` javascript

//  字段描述    是否必填    默认值/注释
{
    "businessmenType":"10",                  //销售方类型               是        10：个体工商户   20：自然人 
    "calNames":"additionalTax",              //计算类型                 是        valueAddedTax:增值税
    "valueAddedTax": 10000000,               //增值税金额 单位：分          是
    "valAddTaxRange": [                      //增值税范围                是
        {
            "minValue": 0,                   //最小值 单位：分            是
            "zengzhiRate": "3",              //增值税百分比               是        如果3%请填写 3
            "fujiaRate": "12",               //附加税     否
            "maxValue": 3000000              //最大值 单位：分             是
        }
    ]
}
```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": "1500000.00",      //附加税
    "bizmsg": "empty",
    "requestid": "833f1dfa957d44fabde9ed71652f0677"
}

```




## **<a name="queryInvoice"> 查询发票明细（平台）</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** '/web/invoice/invoiceCtl/queryInvoice
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string | 否 | 　| 发票ID |
| applyNo | string | 否 | 　| 发票申请号   |
| merchantId | string | 否 | 　| 商户ID  |

**示例**
```
注意：applyNo结合merchantId 一起使用，当id存在是优先使用Id查询
{
	"merchantId":"11665033820002912",
	"applyNo": "1020",
	"id":"xxxx"
}
```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**
```
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "id":"11665033820002912",
        "merchantId":"18asf854584",
        "merchantName":"腾讯信息科有限公司",
        "merchantCreditCode":"5456461654165",
        "merchantAddr":"北京海淀区上地",
        "merchantMobile":"18833836392",
        "merchantBank":"招商银大望路支行",
        "merchantAccount":"tengxunkeji",
        "businessmenId":"12795594625000138",
        "businessmenCreditCode":"91210200MA0QE7GT5L",
        "businessName":"网易信息科技",
        "isBank":"已开户",
        "taxAuthorities":"北京朝阳税务局",
        "type":"普通发票",
        "invoiceAmount":200000,
        "statements":"wwww.baidu.com",
        "contract":"www.qq.com",
        "invoiceTime":"2019-09-19",
        "settleImg":"www.taobao.com",
        "applyNo":"gongsibao001",
        "invoiceContent":null,
        "personalIncomeTax":482926.51,
        "additionalTax":65323.9,
        "valueAddedTax":544365.81,
        "serviceCharge":45,
        "applyMobile":null,
        "isInvalid":"已红冲",
        "parentId":null,
        "status":"1090",
        "customerStatus":"1090",
        "payWay":"系统账户扣款",
        "payAccount":null,
        "isPay":"已支付",
        "mailAddr":"北京来广营",
        "mailMobile":"0-012535",
        "mailTo":"脚姐",
        "remark":"脚姐已批准",
        "delivererId":"11329678846003516",
        "createdAt":"2019-10-25",
        "updatedAt":"2019-10-26T05:36:15.000Z",
        "deletedAt":null,
        "version":0,
        "statusName":"完成",
        "customerStatusName":"",
        "deliverer":{
            "id":"11329678846003516",
            "invoiceId":"11665033820002912",
            "applyNo":"gongsibao001",
            "merchantId":"18asf854584",
            "delivererId":"1536854655",
            "delivererName":"国投迎新科技有限公司",
            "delivererAmount":10,
            "breakReason":null,
            "auditContent":"审核内容信息",
            "delivererContent":"交付商交付内容信息",
            "mailAddr":"北京大望路",
            "mailMobile":"1000",
            "mailTo":"脚姐",
            "delivererMailNo":"JIDNUId625815",
            "platformMailNo":"545sre55sg",
            "createdAt":"2019-10-25",
            "updatedAt":"2019-10-28",
            "deletedAt":null,
            "version":0
        },
        "invoice":{
            "id":"11665033820002912",
            "applyNo":"gongsibao001",
            "merchantId":"18asf854584",
            "status":"1080",
            "invoiceNo":"gongsibao4584585",
            "invoiceTime":"2019-10-12",
            "invoiceImg":"www.baidu.com",
            "taxNo":"DIE552SDKD",
            "complateTax":"已完税",
            "taxTime":"2019-10-10",
            "taxVoucher":null,
            "mailNo":"JIDNUId625815",
            "createdAt":"2019-10-25",
            "updatedAt":"2019-10-26",
            "deletedAt":null,
            "version":0,
            "statusName":"已邮寄"
        },
        "parentInvoice":null
    },
    "bizmsg":"empty",
    "requestid":"9120426859914d88ba56a58709683be4"
}
```





## **<a name="queryInvoiceDeliverer"> 查询发票明细（交付商）</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** '/api/op/action/springboard     
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string | 否 | 　| 发票ID |
| applyNo | string | 否 | 　| 发票申请号   |
| merchantId | string | 是 | 　| 商户ID  |


**示例**
```
注意：applyNo结合merchantId 一起使用，当id存在是优先使用Id查询
{
	"merchantId":"11665033820002912",
	"applyNo": "1020",
	"id":"xxxx"
}
```


**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**
```
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "id":"11665033820002912",
        "delivererId":"11329678846003516",
        "merchantId":"18asf854584",
        "merchantName":"腾讯信息科有限公司",
        "merchantCreditCode":"5456461654165",
        "merchantAddr":"北京海淀区上地",
        "merchantMobile":"18833836392",
        "merchantBank":"招商银大望路支行",
        "merchantAccount":"tengxunkeji",
        "businessmenId":"12795594625000138",
        "businessmenCreditCode":"91210200MA0QE7GT5L",
        "businessName":"网易信息科技",
        "isBank":"未开户",
        "taxAuthorities":"北京朝阳税务局",
        "type":"普通发票",
        "invoiceAmount":20000000,
        "statements":"wwww.baidu.com",
        "contract":"www.qq.com",
        "invoiceTime":"2019-09-19",
        "settleImg":"www.taobao.com",
        "applyNo":"gongsibao001",
        "invoiceContent":null,
        "personalIncomeTax":48292651,
        "additionalTax":6532390,
        "valueAddedTax":54436581,
        "serviceCharge":4500,
        "applyMobile":null,
        "mailAddr":"北京来广营",
        "mailMobile":"0-012535",
        "mailTo":"脚姐",
        "createdAt":"2019-10-25",
        "deliverer":{
            "auditContent":"审核内容信息",
            "delivererContent":"交付商交付内容信息",
            "mailAddr":"北京大望路",
            "mailMobile":"1000",
            "mailTo":"脚姐",
            "delivererMailNo":"JIDNUId625815",
            "status":"1080",
            "statusName":"已邮寄"
        },
        "invoice":{
            "invoiceNo":"gongsibao4584585",
            "invoiceTime":"2019-10-12",
            "invoiceImg":"www.baidu.com",
            "taxNo":"DIE552SDKD",
            "complateTax":"已完税",
            "taxTime":"2019-10-10",
            "taxVoucher":null
        }
    },
    "bizmsg":"empty",
    "requestid":"eecdd1283154468897f30b0c2fd37cb3"
}
```






## **<a name="platformAssignment"> 发票平台第一次审批</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** '/web/invoice/invoiceCtl/platformAssignment'
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string| 是 | 　| 发票申请ID |
| nextStatus | string | 是 | 　| 发票状态 |
| remark | string | 是 | 　| 平台审核备注 |
| isPay | number | 是 |  　| 发票支付  必须写 1  请确认是否已经支付  |

**示例** 

```

{
    "id":"11665430003004143",
    "nextStatus": "1020",
    "isPay": 1,
    "remark": "材料准确无误"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```

{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"ea903ff378d4469a8fef10a6e15f5036"
}

```


## **<a name="platformAssignment"> 分配交付商</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** '/web/invoice/invoiceCtl/platformAssignment'
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string| 是 | 　| 发票申请ID |
| nextStatus | string | 是 | 1030　| 发票状态 |
| merchantId | string | 是 | 　| 购买方ID |
| delivererId | number | 是 |  　| 交付商ID  |
| delivererName | string | 是 |  　| 交付商名称  |
| delivererAmount | string | 是 |  　| 交付商分成 |

**示例** 

```

{
    "id":"11665033820002912",
    "nextStatus": "1030",
    "merchantId":"18asf854584",
    "delivererId":"1536854655",
    "delivererName":"国投迎新科技有限公司",
    "delivererAmount":"1000"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"3ea95f1837b9475da4a4d9aacc3ff74b"
}
```

## **<a name="delivererAssignment"> 交付商开具</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/delivererAssignment
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string| 是 | 　| 发票申请ID |
| nextStatus | string | 是 |  1050　| 发票状态 |
| invoiceNo | string | 是 | 　| 发票编号 |
| invoiceTime | number | 是 |  　| 开具时间  |
| invoiceImg | string | 是 |  　| 发票图片  |

**示例** 

```
{
    "id":"11665430003004143",
    "nextStatus": "1050",
    "invoiceNo":"gongsibao4584585",
    "invoiceTime":"2019-10-12",
    "invoiceImg":"www.baidu.com"
}
```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"3ea95f1837b9475da4a4d9aacc3ff74b"
}
```

## **<a name="delivererAssignment"> 交付商提交审核</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/delivererAssignment
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string| 是 | 　| 发票申请ID |
| nextStatus | string | 是 |  1060 　| 发票状态 |

**示例** 

```
{
    "id":"11665033820002912",
	"nextStatus": "1060",
}
```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"3ea95f1837b9475da4a4d9aacc3ff74b"
}
```


## **<a name="platformAssignment"> 发票平台第二次审核</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** '/web/invoice/invoiceCtl/platformAssignment'
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string| 是 | 　| 发票申请ID |
| nextStatus | string | 是 | 1070　| 发票状态 |
| auditContent | string | 是 | 　| 审核内容 |
| delivererContent | string | 是 |  　| 交付内容  |
| mailAddr | string | 是 |  　| 邮寄地址  |
| mailMobile | string | 是 |  　| 邮寄电话 |
| mailTo | string | 是 |  　| 邮寄人 |

**示例** 

```

{
    "id":"11665430003004143",
    "nextStatus": "1070",
    "auditContent":"审核内容信息",
    "delivererContent":"交付商交付内容信息",
    "mailAddr":"北京大望路",
    "mailMobile":"010-65658565",
    "mailTo":"杨庆菊"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"3ea95f1837b9475da4a4d9aacc3ff74b"
}
```


## **<a name="delivererAssignment"> 交付商邮寄</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/delivererAssignment
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string| 是 | 　| 发票申请ID |
| nextStatus | string | 是 |  1080 　| 发票状态 |
| mailNo | string | 是 |  　| 邮寄单号 |

**示例** 

```
{
    "id":"11665430003004143",
    "nextStatus": "1080",
    "mailNo":"JIDNUId625815"
}
```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"3ea95f1837b9475da4a4d9aacc3ff74b"
}
```

## **<a name="platformAssignment"> 发票平台完成</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/platformAssignment'
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string| 是 | 　| 发票申请ID |
| nextStatus | string | 是 | 1090　| 发票状态 |

**示例** 

```

{
    "id":"11665430003004143",
	"nextStatus": "1090"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```
{
    "status":0,
    "msg":"success",
    "data":null,
    "requestid":"3ea95f1837b9475da4a4d9aacc3ff74b"
}
```

## **<a name="apiCancelInvoice"> 发票撤销</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** '/api/op/action/springboard
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| merchantId | string | 是 | 　| 平台审核备注 |
| applyNo | number | 是 |  　| 发票支付  必须写 1  请确认是否已经支付  |

**示例** 

```

{
    "action_process": "sijibao",
    "action_type": "apiCancelInvoice",
    "action_body": {
    	    "merchantId":"11665033820002912",
	    "applyNo": "1020"
	}
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

## **<a name="txPayment"> 完税证明 </a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/txPayment
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|

| id | number | 是 | 　| 发票ID |
| taxNo | number | 是 | 　| 发票编号 |
| complateTax | string | 是 | 　| 是否完税 |
| taxTime | string | 是 | 　| 完税时间 |
| taxVoucher | string | 是 | 　| 完税图片 |

**示例** 

```
{
    "id":"11665448190004592",
    "taxNo": "DIE552SDKD",
    "complateTax":1,
    "taxTime":"2019-10-10",
    "taxVoucher":"www.baidu.com"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |


## **<a name="queryTxPayment"> 查看完税证明</a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** '/api/op/action/springboard
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string | 是 | 　| 发票ID |

**示例** 

```
{
    "id":"11665033820002912"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

```
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "invoiceTime":"2019-10-31 13:09:03",
        "complateTax":"已完成",
        "taxTime":"2019-10-10 08:00:00",
        "createdAt":"2019-10-31 13:09:03",
        "updatedAt":"2019-10-31 13:09:03",
        "id":"11665448190004592",
        "taxNo":"DIE552SDKD",
        "taxVoucher":"www.baidu.com"
    },
    "bizmsg":"empty",
    "requestid":"b00a9b2244504505bf1ef1bc36b6949e"
}

```

## **<a name="apiUpEmNo"> 平台更新邮寄号 </a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** '/api/op/action/springboard
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|
| id | string | 是 | 　| 发票ID |
| platformMailNo | string | 是 | 　| 邮寄编号 |

**示例** 

```
{
    "id":"11665033820002912",
    "platformMailNo":"545sre55sg"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |


## **<a name="queryInvoices"> 发票列表（平台） </a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/queryInvoices
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|

| pageIndex | number | 否 | 1　| 当前页数 |
| pageSize | number | 否 | 10　| 每页记录数 |
| complateTax | string | 否 | 　| 是否完税 |
| invoiceTime | string | 否 | 　| 开发票时间 |
| applyNo | string | 否 | 　| 发票申请编号 |
| inInvalid | string | 否 | 　| 是否完税 |
| type | string | 否 | 　| 发票类型 |

**示例** 

```
{
   "type":"10"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "count":3,
        "rows":[
            {
                "invoiceTime":"2019-10-28 10:22:05",
                "complateTax":"未完成",
                "taxTime":"2019-10-28 10:22:05",
                "createdAt":"2019-10-28 10:22:05",
                "updatedAt":"2019-10-28 10:22:05",
                "id":"11665258555003154",
                "applyNo":"gongsibao001",
                "merchantId":"18asf854584",
                "status":"1030",
                "invoiceNo":"",
                "invoiceImg":null,
                "taxNo":"",
                "taxVoucher":null,
                "mailNo":"",
                "deletedAt":null,
                "version":0,
                "apply":{
                    "isInvalid":"红冲",
                    "createdAt":"2019-10-31 12:15:42",
                    "updatedAt":"2019-10-31 12:15:42",
                    "type":10,
                    "applyNo":"gongsibao001",
                    "merchantName":"腾讯信息科有限公司",
                    "businessName":"悦图遥感科技"
                }
            },
            {
                "invoiceTime":"2019-10-26 14:41:42",
                "complateTax":"已完成",
                "taxTime":"2019-10-10 08:00:00",
                "createdAt":"2019-10-25 19:56:30",
                "updatedAt":"2019-10-26 14:41:42",
                "id":"11665033820002912",
                "applyNo":"gongsibao001",
                "merchantId":"18asf854584",
                "status":"1080",
                "invoiceNo":"gongsibao4584585",
                "invoiceImg":"www.baidu.com",
                "taxNo":"DIE552SDKD",
                "taxVoucher":null,
                "mailNo":"JIDNUId625815",
                "deletedAt":null,
                "version":0,
                "apply":{
                    "isInvalid":"未红冲",
                    "createdAt":"2019-10-31 12:15:42",
                    "updatedAt":"2019-10-31 12:15:42",
                    "type":10,
                    "applyNo":"gongsibao001",
                    "merchantName":"腾讯信息科有限公司",
                    "businessName":"网易信息科技"
                }
            },
            {
                "invoiceTime":"2019-10-25 17:38:48",
                "complateTax":"未完成",
                "taxTime":"2019-10-25 17:36:36",
                "createdAt":"2019-10-25 17:36:36",
                "updatedAt":"2019-10-25 17:38:48",
                "id":"11665025426002758",
                "applyNo":"zjietiaodong999",
                "merchantId":"11064622752480998",
                "status":"1030",
                "invoiceNo":"",
                "invoiceImg":null,
                "taxNo":"",
                "taxVoucher":null,
                "mailNo":"",
                "deletedAt":null,
                "version":0,
                "apply":{
                    "isInvalid":"红冲",
                    "createdAt":"2019-10-31 12:15:42",
                    "updatedAt":"2019-10-31 12:15:42",
                    "type":10,
                    "applyNo":"zjietiaodong999",
                    "merchantName":"网易科技",
                    "businessName":"zijietiaodongmingcheng"
                }
            }
        ]
    },
    "bizmsg":"empty",
    "requestid":"8296ad60d1bc46b8a73f7405f2861aec"
}

```

## **<a name="queryInvoices"> 发票申请列表（平台） </a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/queryInvoices
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|

| pageIndex | number | 否 | 1　| 当前页数 |
| pageSize | number | 否 | 10　| 每页记录数 |
| invoiceTime | string | 是 | 　| 开发票时间 |
| applyNo | string | 是 | 　| 发票申请编号 |
| type | string | 是 | 　| 发票类型 |
| status | string | 是 | 　| 发票状态 |

**示例** 

```
{
   "type":"10"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

```
{
    "status":0,
    "msg":"操作成功",
    "data":{
        "count":3,
        "rows":[
            {
                "invoiceTime":"2019-10-28 10:22:05",
                "complateTax":"未完成",
                "taxTime":"2019-10-28 10:22:05",
                "createdAt":"2019-10-28 10:22:05",
                "updatedAt":"2019-10-28 10:22:05",
                "id":"11665258555003154",
                "applyNo":"gongsibao001",
                "merchantId":"18asf854584",
                "status":"1030",
                "invoiceNo":"",
                "invoiceImg":null,
                "taxNo":"",
                "taxVoucher":null,
                "mailNo":"",
                "deletedAt":null,
                "version":0,
                "apply":{
                    "isInvalid":"红冲",
                    "createdAt":"2019-10-31 12:15:42",
                    "updatedAt":"2019-10-31 12:15:42",
                    "type":10,
                    "applyNo":"gongsibao001",
                    "merchantName":"腾讯信息科有限公司",
                    "businessName":"悦图遥感科技"
                }
            },
            {
                "invoiceTime":"2019-10-26 14:41:42",
                "complateTax":"已完成",
                "taxTime":"2019-10-10 08:00:00",
                "createdAt":"2019-10-25 19:56:30",
                "updatedAt":"2019-10-26 14:41:42",
                "id":"11665033820002912",
                "applyNo":"gongsibao001",
                "merchantId":"18asf854584",
                "status":"1080",
                "invoiceNo":"gongsibao4584585",
                "invoiceImg":"www.baidu.com",
                "taxNo":"DIE552SDKD",
                "taxVoucher":null,
                "mailNo":"JIDNUId625815",
                "deletedAt":null,
                "version":0,
                "apply":{
                    "isInvalid":"未红冲",
                    "createdAt":"2019-10-31 12:15:42",
                    "updatedAt":"2019-10-31 12:15:42",
                    "type":10,
                    "applyNo":"gongsibao001",
                    "merchantName":"腾讯信息科有限公司",
                    "businessName":"网易信息科技"
                }
            },
            {
                "invoiceTime":"2019-10-25 17:38:48",
                "complateTax":"未完成",
                "taxTime":"2019-10-25 17:36:36",
                "createdAt":"2019-10-25 17:36:36",
                "updatedAt":"2019-10-25 17:38:48",
                "id":"11665025426002758",
                "applyNo":"zjietiaodong999",
                "merchantId":"11064622752480998",
                "status":"1030",
                "invoiceNo":"",
                "invoiceImg":null,
                "taxNo":"",
                "taxVoucher":null,
                "mailNo":"",
                "deletedAt":null,
                "version":0,
                "apply":{
                    "isInvalid":"红冲",
                    "createdAt":"2019-10-31 12:15:42",
                    "updatedAt":"2019-10-31 12:15:42",
                    "type":10,
                    "applyNo":"zjietiaodong999",
                    "merchantName":"网易科技",
                    "businessName":"zijietiaodongmingcheng"
                }
            }
        ]
    },
    "bizmsg":"empty",
    "requestid":"8296ad60d1bc46b8a73f7405f2861aec"
}

```

## **<a name="delivererInvoices"> 发票列表（交付商） </a>**　　　　　
[返回到目录](#menu)　　　　　

**接口方式** HTTP    
**HTTP方法** POST    
**URI路径** /web/invoice/invoiceCtl/delivererInvoices
**参数验证** 否     
**参数**    

| 参数名|数据类型|必须|默认| 说明 |
|---|:---:|:---:|:---:|---|

| pageIndex | number | 否 | 1　| 当前页数 |
| pageSize | number | 否 | 10　| 每页记录数 |
| complateTax | string | 否 | 　| 是否完税 |
| invoiceTime | string | 否 | 　| 开发票时间 |
| applyNo | string | 否 | 　| 发票申请编号 |
| inInvalid | string | 否 | 　| 是否完税 |
| type | string | 否 | 　| 发票类型 |

**示例** 

```
{
   "type":"10"
}

```

**返回结果**   

| 参数名|数据类型| 说明 |
|---|:---:|---|
| status | Number | 状态码 |
| msg | String | 提示信息 |
| data | JSON | 返回值 |

**示例**

{
    "status":0,
    "msg":"操作成功",
    "data":{
        "count":2,
        "rows":[
            {
                "applyNo":"gongsibao-futong001",
                "invoiceId":"11665448190004592",
                "breakReason":null,
                "apply":{
                    "merchantId":"11064622752480055",
                    "merchantName":"司机宝",
                    "type":"增值税专用发票",
                    "invoiceAmount":400000000,
                    "invoiceTime":"2019-10-19",
                    "businessName":"北京富通勤国际贸易有限责任公司（个体工商）"
                },
                "invoice":{
                    "invoiceNo":"gongsibao4584585",
                    "status":"1060",
                    "statusName":"待审核"
                }
            },
            {
                "applyNo":"gongsibao-futong001",
                "invoiceId":"11665448190004592",
                "breakReason":"业务繁忙",
                "apply":{
                    "merchantId":"11064622752480055",
                    "merchantName":"司机宝",
                    "type":"增值税专用发票",
                    "invoiceAmount":400000000,
                    "invoiceTime":"2019-10-19",
                    "businessName":"北京富通勤国际贸易有限责任公司（个体工商）"
                },
                "invoice":{
                    "invoiceNo":"gongsibao4584585",
                    "status":"1060",
                    "statusName":"待审核"
                }
            }
        ]
    },
    "bizmsg":"empty",
    "requestid":"21da505b34d7423fbbb8865d64f652a5"
}

```