const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
class AuthCtl extends CtlBase {
  constructor() {
    super('auth', CtlBase.getServiceName(AuthCtl));
  }
  async saveAuths(pobj, query, req) {
    const { auths } = pobj;
    const xrtn = await this.service.saveAuths(auths, pobj.app_id, pobj.company_id);
    return system.getResult(xrtn);
  }
  async findAuthsByRoles(pobj, query, req) {
    const { roleids } = pobj;
    const xrtn = await this.service.findAuthsByRole(roleids, pobj.app_id, pobj.company_id);
    return system.getResult(xrtn);
  }
}
module.exports = AuthCtl;
