const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
const moment = require('moment');
class SchemeCtl extends CtlBase {
  constructor() {
    super('bizchance', CtlBase.getServiceName(SchemeCtl));
  }
  async create(pobj, qobj, req) {
    if (!pobj.bizopt_id) {
      return system.getResult(null, 'bizopt_id can not be empty，100290');
    }
    try {
      const data = await this.service.create(pobj);
      return system.getResult(data);
    } catch (err) {
      return system.getResult(null, err.message);
    }
  }
  async findOne(pobj, qobj, req) {
    if (!pobj.bizopt_id) {
      return system.getResult(null, 'bizopt_id can not be empty，100290');
    }
    const rs = await this.service.findOne({ bizopt_id: pobj.bizopt_id });
    return system.getResult(rs);
  }
}
module.exports = SchemeCtl;
