const system = require('../../../system');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
const uuidv4 = require('uuid/v4');
const moment = require('moment');
class OplogCtl extends CtlBase {
  constructor() {
    super('common', CtlBase.getServiceName(OplogCtl));
    // this.appS=system.getObject("service.appSve");
  }

  async initNewInstance(qobj) {
    const u = uuidv4();
    const aid = u.replace(/-/g, '');
    const rd = { name: '', appid: aid };
    return system.getResult(rd);
  }
  async debug(obj) {
    obj.logLevel = 'debug';
    return this.create(obj);
  }
  async info(obj) {
    obj.logLevel = 'info';
    return this.create(obj);
  }
  async warn(obj) {
    obj.logLevel = 'warn';
    return this.create(obj);
  }
  async error(obj) {
    obj.logLevel = 'error';
    return this.create(obj);
  }
  async fatal(obj) {
    obj.logLevel = 'fatal';
    return this.create(obj);
  }

  /*
返回20位业务订单号
prefix：业务前缀
*/
  async getBusUidCtl(prefix) {
    prefix = (prefix || '');
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    const prefixlength = prefix.length;
    const subLen = 8 - prefixlength;
    let uidStr = '';
    if (subLen > 0) {
      uidStr = await this.getUidInfo_Ctl(subLen, 60);
    }
    const timStr = moment().format('YYYYMMDDHHmm');
    return prefix + timStr + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfoCtl(len, radix) {
    const chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');// 长度62，到yz长度为长36
    const uuid = []; let i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      let r;
      uuid[23] = '-';
      uuid[18] = uuid[23];
      uuid[13] = uuid[18];
      uuid[8] = uuid[13];
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }
}
module.exports = OplogCtl;
