const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');


const cacheBaseComp = null;
class RouteCtl extends CtlBase {
  constructor() {
    super('common', CtlBase.getServiceName(RouteCtl));
    this.appS = system.getObject('service.common.appSve');
  }
  async create(p, q, req) {
    const appid = p.app_id;
    const apptmp = await this.appS.findById(appid);
    const routedata = {
      name: p.name,
      hosts: p.shosts.split(','),
      paths: p.spaths.split(','),
      isstrip: false,
      app_id: appid,
      shosts: p.shosts,
      spaths: p.spaths,
    };
    const rtn =  await this.service.create(apptmp.name, routedata, req);
    return system.getResult(rtn);
  }
}
module.exports = RouteCtl;
