const CacheBase = require('../cache.base');
const system = require('../../system');
const settings = require('../../../config/settings');
// 缓存首次登录的赠送的宝币数量
class VCodeCache extends CacheBase {
  constructor() {
    super();
    this.smsUtil = system.getObject('util.smsClient');
  }
  // isdebug() {
  //   return settings.env == "dev";
  // }
  desc() {
    return '缓存给手机发送的验证码60妙';
  }
  prefix() {
    return 'g_vcode_';
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    // inputkey采用appkey_mobile的形式
    const mobile = inputkey;
    const tmplCode = val;
    const signName = items ? items[0] : '';
    const vcode = await this.smsUtil.getUidStr(6, 10);
    if (!tmplCode && !signName) {
      this.smsUtil.sendMsg(mobile, vcode);
    } else {
      this.smsUtil.aliSendMsg(mobile, tmplCode, signName, JSON.stringify({ code: vcode }));
    }
    return JSON.stringify({ vcode });
  }
}
module.exports = VCodeCache;
