const system = require('../../../system');
const Dao = require('../../dao.base');
const url = require('url');
class DeliverDao extends Dao {
  constructor() {
    super(Dao.getModelName(DeliverDao));
  }
  orderBy() {
    return [['updated_at', 'DESC']];
  }
  extraWhere(qobj, qw, qc) {
    // 权限添加
    // 需要添加公司查询条件
    qc.where.facilitator_id = Number(qobj.company_id || -1);
    // 组织结构
    if (qobj.opath && qobj.opath != '') {
      qc.where.$or = [
        {
          delivery_man_opcode: { [this.db.Op.like]: `%${qobj.opath}%` },
        },
        {
          salesman_opcode: { [this.db.Op.like]: `%${qobj.opath}%` },
        },
      ];
    }

    const { search: { product_code } } = qobj;
    qc.raw = true;
    const type = qobj.bizpath.split('/')[1];
    if (type === 'deliveryManagement') {
      qc.where.product_code = (
        (product_code && [system.SERVICECODE.EDI, system.SERVICECODE.ICP].includes(product_code))
          ? product_code
          : {
            $in: [system.SERVICECODE.EDI, system.SERVICECODE.ICP],
          });


      switch (qobj.bizpath) {
        case '/deliveryManagement/wait':
          qc.where.delivery_status = qc.where.delivery_status || {
            $in: [system.SERVERSESTATUS.RECEIVED, system.SERVERSESTATUS.COLLECTING,
              system.SERVERSESTATUS.SUBMITING, system.SERVERSESTATUS.DISPOSEING, system.SERVERSESTATUS.POSTING,
            ],
          };
          break;
        case '/deliveryManagement/deliveryAllocated':
          qc.where.delivery_man_id = qc.where.delivery_man_id || {
            $and: [{ $not: null }, { $not: '' }],
          };
          break;
        case '/deliveryManagement/deliveryNoAllocate':
          qc.where.delivery_man_id = qc.where.delivery_man_id || {
            $or: [{ $eq: null }, { $eq: '' }],
          };
          break;
        case '/deliveryManagement/all':
          break;
      }
    } else if (type === 'annualReport') {
      qc.where.product_code = (
        (product_code
          && [system.SERVICECODE.ICPANNUALREPORT, system.SERVICECODE.EDIANNUALREPORT].includes(product_code))
          ? product_code
          : {
            $in: [system.SERVICECODE.EDIANNUALREPORT, system.SERVICECODE.ICPANNUALREPORT],
          });

      // ---- 兼容 年报 状态 未申报、已申报 start
      let status;
      if ([system.ANNUALREPORT.WAITDECLARE, system.ANNUALREPORT.DECLARESUCCESS].includes(qc.where.delivery_status)) {
        status = qc.where.delivery_status;
        delete qc.where.delivery_status;
        qobj.bizpath = '/annualReport/wait';
      }
      const include = {
        model: this.db.models.annualreport,
        attributes: ['status', 'year'],
        where: {
          year: {
            $or: [
              new Date().getFullYear(),
              null,
            ],
          },
        },
        required: false,
      };
      if (status) {
        include.where.status = status;
        delete include.required;
      }

      qc.include = [
        include,
      ];
      // ---- 兼容 年报 状态 未申报、已申报 end

      switch (qobj.bizpath) {
        case '/annualReport/wait':
          qc.where.delivery_status = qc.where.delivery_status || {
            $in: [system.ANNUALREPORT.TAKEEFFECT],
          };
          break;
        case '/annualReport/all':
          qc.where.delivery_status = qc.where.delivery_status || {
            $in: [system.ANNUALREPORT.TAKEEFFECT, system.ANNUALREPORT.SUCCESS],
          };
          break;
      }
    }

    return qw;
  }

  async findInfo(pobj) {
    const result = await this.model.findOne({
      where: {
        id: pobj.id,
      },
      include: [
        {
          model: this.db.models.qualification,
          raw: false,
        }, {
          model: this.db.models.material,
          raw: false,
        },
      ],
      raw: false,
    });
    return result;
  }
  async findAnnualReportInfo(pobj) {
    const result = await this.model.findOne({
      where: {
        id: pobj.id,
      },
      include: [
        {
          model: this.db.models.annualreport,
        },
      ],
      raw: false,
    });
    return result;
  }
}
module.exports = DeliverDao;
