const system = require('../../../system');
const Dao = require('../../dao.base');
class MsgNoticeDao extends Dao {
  constructor() {
    super(Dao.getModelName(MsgNoticeDao));
  }

  async saveNotice(msg, t) {
    let noticeFrom = await super.findOne({ fromId: msg.senderId, toId: msg.targetId });
    if (noticeFrom) {
      const set = { lastMsgId: msg.id };
      if (msg.businessLicense_id) {
        set.businessLicense_id = msg.businessLicense_id;
      }
      await super.updateByWhere(set, { where: { id: noticeFrom.id } }, t);
    } else {
      noticeFrom = {
        fromuser: msg.sender,
        fromId: msg.senderId,
        touser: msg.target,
        toId: msg.targetId,
        isAccepted: true,
        lastMsgId: msg.id,
        businessLicense_id: msg.businessLicense_id || 0,
      };
      await super.create(noticeFrom, t);
    }

    let noticeTo = await super.findOne({ fromId: msg.targetId, toId: msg.senderId });
    if (noticeTo) {
      const set = { lastMsgId: msg.id };
      if (msg.businessLicense_id) {
        set.businessLicense_id = msg.businessLicense_id;
      }
      await super.updateByWhere(set, { where: { id: noticeTo.id } }, t);
    } else {
      noticeTo = {
        fromuser: msg.target,
        fromId: msg.targetId,
        touser: msg.sender,
        toId: msg.senderId,
        isAccepted: true,
        lastMsgId: msg.id,
        businessLicense_id: msg.businessLicense_id || 0,
      };
      await super.create(noticeTo, t);
    }
  }

  orderBy() {
    // return {"key":"include","value":{model:this.db.models.app}};
    return [['id', 'DESC']];
  }
}
module.exports = MsgNoticeDao;
