﻿const url = require('url');
const system = require('../../base/system');
const metaCtl = system.getObject('web.common.metaCtl');
module.exports = function (app) {
  app.get('/web/:gname/:qname/:method', (req, res) => {
    let classPath = req.params.qname;
    const methodName = req.params.method;
    const { gname } = req.params;
    classPath = `${gname}.${classPath}`;
    const params = [];
    params.push(methodName);
    params.push(req.body);
    params.push(req.query);
    params.push(req);
    let p = null;
    const invokeObj = system.getObject(`web.${classPath}`);
    if (invokeObj.doexec) {
      p = invokeObj.doexec.apply(invokeObj, params);
      p.then((r) => {
        res.end(JSON.stringify(r));
      });
    }
  });
  app.post('/web/:gname/:qname/:method', (req, res) => {
    req.codepath = req.headers.codepath;
    let classPath = req.params.qname;
    const methodName = req.params.method;
    const { gname } = req.params;
    const params = [];
    classPath = `${gname}.${classPath}`;
    const tClientIp = system.getClientIp(req);
    req.body.clientIp = tClientIp;
    req.body.agent = req.headers['user-agent'];
    req.body.classname = classPath;
    params.push(methodName);
    params.push(req.body);
    params.push(req.query);
    params.push(req);
    let p = null;
    const invokeObj = system.getObject(`web.${classPath}`);
    if (invokeObj.doexec) {
      p = invokeObj.doexec.apply(invokeObj, params);
      p.then((r) => {
        res.end(JSON.stringify(r));
      });
    }
  });
};
