var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class ActionAPI extends APIBase {
    constructor() {
        super();
        this.productSve = system.getObject("service.product.productSve")
    }
    /**
     * 接口跳转
     * action_process  执行的流程
     * action_type     执行的类型
     * action_body     执行的参数
     */
    async springboard (pobj, qobj, req) {
        var result;
        if (!pobj.action_process) {
            return system.getResult(null, "action_process参数不能为空");
        }
        if (!pobj.action_type) {
            return system.getResult(null, "action_type参数不能为空");
        }
        try {
            result = await this.handleRequest(pobj.action_process, pobj.action_type, pobj.action_body);
        } catch (error) {
            console.log(error);
        }

        return result;
    }

    async handleRequest (action_process, action_type, action_body) {
        let result
        switch (action_type) {
            case 'getPage':
                result = await this.productSve.getPage(action_body.page, action_body.limit,
                    action_body.types, action_body.keywords)
                break
            case 'createOrUpdate':
                if (action_body.product_type == 1 && action_body.items) {
                    return system.getResult(null, '单产品不能有子产品')
                }
                if (action_body.product_type == 2 && (!action_body.items || action_body.items.length == 0)) {
                    return system.getResult(null, '未选择子产品')
                }
                if (action_body.product_type == 2) {
                    let checkRes = await this.productSve.checkSitem(action_body.items)
                    if (!checkRes) {
                        return system.getResult(null, '不能选择组合产品为子产品')
                    }
                }
                result = await this.productSve.createOrUpdate(action_body)
                break
            case 'getAllDic':
                result = await this.productSve.getAllDic(action_body.types)
                break;
            case 'getByIds':
                if (!action_body.ids) {
                    return system.getResult(null, 'id列表不能为空')
                }
                result = await this.productSve.getByIds(action_body.ids)
                break;
            case 'getItems':
                result = await this.productSve.getItems(action_body.id)
                break;
            case 'apiList':
                result = await this.productSve.apiList(action_body);
                break;
            case 'apiMap':
                result = await this.productSve.apiMap(action_body);
                break;
            default:
                break
        }
        return system.getResultSuccess(result)
    }
    exam () {
        return `<pre><pre/>`;
    }
    classDesc () {
        return {
            groupName: "op",
            groupDesc: "元数据服务包",
            name: "ActionAPI",
            desc: "此类是对外提供接口服务",
            exam: "",
        };
    }
    methodDescs () {
        return [
            {
                methodDesc: `<pre><pre/>`,
                methodName: "springboard",
                paramdescs: [
                    {
                        paramDesc: "请求的行为，传递如：sjb",
                        paramName: "action_process",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型，详情见方法中的描述",
                        paramName: "action_type",
                        paramType: "string",
                        defaultValue: null,
                    },
                    {
                        paramDesc: "业务操作类型的参数，action_body必须传递的参数有，times_tamp（时间戳，类型int）、sign(签名,类型string)，其余的为业务需要的参数",
                        paramName: "action_body",
                        paramType: "json",
                        defaultValue: null,
                    }
                ],
                rtnTypeDesc: `<pre><pre/>`,
                rtnType: `<pre><pre/>`
            }
        ];
    }
}
module.exports = ActionAPI;