const system = require("../system");
const moment = require('moment')
const settings = require("../../config/settings");
const md5 = require("MD5");
class ServiceBase {
  constructor(gname, daoName) {
    //this.dbf=system.getObject("db.connection");
    this.db = system.getObject("db.common.connection").getCon();
    this.cacheManager = system.getObject("db.common.cacheManager");
    this.daoName = daoName;
    this.dao = system.getObject("db." + gname + "." + daoName);
    this.restS = system.getObject("util.restClient");
  }
  /**
   * 验证签名
   * @param {*} params 要验证的参数 
   * @param {*} app_key 应用的校验key
   */
  async verifySign(params, app_key) {
    if (!params) {
      return system.getResult(null, "请求参数为空");
    }
    if (!params.sign) {
      return system.getResult(null, "请求参数sign为空");
    }
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResult(null, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey] && !(params[tKey] instanceof Array)) {
        signArr.push(tKey + "=" + params[tKey]);
      }
    }
    if (signArr.length == 0) {
      return system.getResult(null, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_key;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    if (params.sign != resultTmpSign) {
      return system.getResult(null, "返回值签名验证失败");
    }
    return system.getResultSuccess();
  }
  /**
 * 创建签名
 * @param {*} params 要验证的参数 
* @param {*} app_key 应用的校验key
 */
  async createSign(params, app_key) {
    if (!params) {
      return system.getResultFail(-310, "请求参数为空");
    }
    var signArr = [];
    var keys = Object.keys(params).sort();
    if (keys.length == 0) {
      return system.getResultFail(-330, "请求参数信息为空");
    }
    for (let k = 0; k < keys.length; k++) {
      const tKey = keys[k];
      if (tKey != "sign" && params[tKey] && !(params[tKey] instanceof Array)) {
        signArr.push(tKey + "=" + params[tKey]);
      }
    }
    if (signArr.length == 0) {
      return system.getResultFail(-350, "请求参数组装签名参数信息为空");
    }
    var resultSignStr = signArr.join("&") + "&key=" + app_key;
    var resultTmpSign = md5(resultSignStr).toUpperCase();
    return system.getResultSuccess(resultTmpSign);
  }
  /**
   * 验证参数信息不能为空
   * @param {*} params 验证的参数
   * @param {*} verifyParamsCount 需要验证参数的数量，如至少验证3个，则传入3
   * @param {*} columnList 需要过滤掉的验证参数列表，格式:[]
   */
  async verifyParams(params, verifyParamsCount, columnList) {
    if (!params) {
      return system.getResult(null, "请求参数为空");
    }
    if (!columnList) {
      columnList = [];
    }
    var keys = Object.keys(params);
    if (keys.length == 0) {
      return system.getResult(null, "请求参数信息为空");
    }
    if (keys.length < verifyParamsCount) {
      return system.getResult(null, "请求参数不完整");
    }
    var tResult = system.getResultSuccess();
    for (let k = 0; k < keys.length; k++) {
      const tKeyValue = keys[k];
      if (columnList.length == 0 || columnList.indexOf(tKeyValue) < 0) {
        if (!tKeyValue) {
          tResult = system.getResult(null, k + "参数不能为空");
          break;
        }
      }//白名单为空或不在白名单中，则需要验证不能为空
    }
    return tResult;
  }
  async apiCallWithAk(url, params) {
    var acckapp = await this.cacheManager["ApiAccessKeyCache"].cache(settings.appKey);
    var acck = acckapp.accessKey;
    //按照访问token
    var restResult = await this.restS.execPostWithAK(params, url, acck);
    if (restResult) {
      if (restResult.status == 0) {
        var resultRtn = restResult.data;
        return resultRtn;
      } else {
        await this.cacheManager["ApiAccessKeyCache"].invalidate(settings.appKey);
        return null;
      }
    }
    return null;
  }
  // async apiCallWithAkNoWait(url,params){
  //   var acckapp=await this.cacheManager["ApiAccessKeyCache"].cache(settings.appKey);
  //   var acck=acckapp.accessKey;
  //   //按照访问token
  //   var restResult=await this.restS.execPostWithAK(params,url,acck);
  //   if(restResult){
  //     if(restResult.status==0){
  //       var resultRtn=restResult.data;
  //       return resultRtn;
  //     }else{
  //       await  this.cacheManager["ApiAccessKeyCache"].invalidate(settings.appKey);
  //       return null;
  //     }
  //   }
  //   return null;
  // }
  static getDaoName(ClassObj) {
    return ClassObj["name"].substring(0, ClassObj["name"].lastIndexOf("Service")).toLowerCase() + "Dao";
  }
  async findAndCountAll(obj) {
    const apps = await this.dao.findAndCountAll(obj);
    return apps;
  }
  async refQuery(qobj) {
    return this.dao.refQuery(qobj);
  }
  async bulkDelete(ids) {
    var en = await this.dao.bulkDelete(ids);
    return en;
  }
  async delete(qobj) {
    return this.dao.delete(qobj);
  }
  async create(qobj) {
    return this.dao.create(qobj);
  }
  async update(qobj, tm = null) {
    return this.dao.update(qobj, tm);
  }
  async updateByWhere(setObj, whereObj, t) {
    return this.dao.updateByWhere(setObj, whereObj, t);
  }
  async customExecAddOrPutSql(sql, paras = null) {
    return this.dao.customExecAddOrPutSql(sql, paras);
  }
  async customQuery(sql, paras, t) {
    return this.dao.customQuery(sql, paras, t);
  }
  async findCount(whereObj = null) {
    return this.dao.findCount(whereObj);
  }
  async findSum(fieldName, whereObj = null) {
    return this.dao.findSum(fieldName, whereObj);
  }
  async getPageList(pageIndex, pageSize, whereObj = null, orderObj = null, attributesObj = null, includeObj = null) {
    return this.dao.getPageList(pageIndex, pageSize, whereObj, orderObj, attributesObj, includeObj);
  }
  async findOne(obj) {
    return this.dao.findOne(obj);
  }
  async findById(oid) {
    return this.dao.findById(oid);
  }
  /*
  返回20位业务订单号
  prefix：业务前缀
  */
  async getBusUid(prefix) {
    prefix = (prefix || "");
    if (prefix) {
      prefix = prefix.toUpperCase();
    }
    var prefixlength = prefix.length;
    var subLen = 8 - prefixlength;
    var uidStr = "";
    if (subLen > 0) {
      uidStr = await this.getUidInfo(subLen, 60);
    }
    var timStr = moment().format("YYYYMMDDHHmm");
    return prefix + timStr + uidStr;
  }
  /*
  len：返回长度
  radix：参与计算的长度，最大为62
  */
  async getUidInfo(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
    var uuid = [], i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }

  handleDate(row, fields, pattern, addHours) {
    pattern = pattern || "YYYY-MM-DD HH:mm:ss";
    if (!row) {
      return;
    }
    for (var field of fields) {
      if (row[field]) {
        if(addHours) {
          row[field] = moment(row[field]).add(addHours,"hours").format(pattern);
        } else {
          row[field] = moment(row[field]).format(pattern);
        }
        
      }
    }
  }
  handleRowsDate(rows, fields, pattern, addHours) {
    pattern = pattern || "YYYY-MM-DD HH:mm:ss";
    if (!rows) {
      return;
    }
    for (let row of rows) {
      this.handleDate(row, fields, pattern, addHours)
    }
  }

  addWhereTime(where, field, begin, end) {
    if(!begin && !end) {
      return;
    }

    if (begin && end) {
      where[field] = {
        [this.db.Op.between]: [begin, end]
      };
    } else if (begin && !end) {
      where[field] = {
        [this.db.Op.gte]: begin
      };
    } else if (!begin && end) {
      where[field] = {
        [this.db.Op.lte]: end
      };
    }
  }

  trim(o) {
    if(!o) {
      return "";
    }
    return o.toString().trim();
  }

  async getEncryptStr(str) {
    str = this.trim(str);
    if (!str) {
      throw new Error("字符串不能为空");
    }
    var pwd = md5(str + "_" + settings.salt);
    return pwd.toString().toLowerCase();
  }
}
module.exports = ServiceBase;
