<a name="menu">目录</a>

1. [产品分页查询](#getPage)
2. [查询字典(根据 type 查询所有 name 数据)](#getAllDic)
3. [根据 id 数组查询](#getByIds)
4. [获取组合产品子产品列表](#getItems)
5. [添加/更新产品](#createOrUpdate)

## **<a name="getPage"> 产品分页查询 </a>**

[返回到目录](#menu)

#### 参数格式 `JSON`

#### HTTP 请求方式 `POST`

#### 接口地址 `/api/op/product/etag`

#### action_type `getPage`

#### 参数说明

| 参数名   | 参数类型 | 必选项 | 备注                 |
| -------- | -------- | ------ | -------------------- |
| page     | number   | 可选   | 页数 默认 1          |
| limit    | number   | 可选   | 每页条数 默认 10     |
| types    | list     | 可选   | 所选类别 默认 [1, 2] |
| keywords | string   | 可选   | 关键字               |

#### 参数示例

```javascript
{
     "types": [0],
     "keywords": "s",
     "page": 1,
     "limit": 1
}
```

#### 返回结果

```javascript
{
    "status":0,
    "msg":"success",
    "data":{
        "count":1,
        "rows":[
            {
                "id":7,
                "source_id":10001, // 产品来源 id
                "product_name":"ssda", // 产品名称
                "product_type":0, // 产品类型
                "product_desc":"0", // 产品描述
                "price":0, // 产品价格
                "cost":0,
                "created_at":"2020-06-29T11:31:35.000Z",
                "updated_at":"2020-06-29T11:31:41.000Z",
                "deleted_at":null,
                "version":0
            }]
    },
    "requestid":"453c672537b8469d848e4c2899273d4d"
}
```

## **<a name="getAllDic"> 产品字典 </a>**

[返回到目录](#menu)

#### 参数格式 `JSON`

#### HTTP 请求方式 `POST`

#### 接口地址 `/api/op/product/etag`

#### action_type `getAllDic`

#### 参数说明

| 参数名 | 参数类型 | 必选项 | 备注                 |
| ------ | -------- | ------ | -------------------- |
| types  | list     | 可选   | 所选类别 默认 [1, 2] |

#### 参数示例

```javascript
{
     "types": [0]
}
```

#### 返回结果

```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":7,
            "product_type":0, // 产品类型
            "product_name":"ssda" // 产品名称
        }],
    "requestid":"7451247abe9546d88a93c274d5d9c90a"
}

```

## **<a name="getByIds"> 根据 id 数组查询 </a>**

[返回到目录](#menu)

#### 参数格式 `JSON`

#### HTTP 请求方式 `POST`

#### 接口地址 `/api/op/product/etag`

#### action_type `getByIds`

#### 参数说明

| 参数名 | 参数类型 | 必选项 | 备注         |
| ------ | -------- | ------ | ------------ |
| ids    | list     | 必选   | 产品 id 列表 |

#### 参数示例

```javascript
{
     "ids": [1, 2, 6, 7]
}
```

#### 返回结果

```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":6,
            "source_id":10001,
            "product_name":"asdf", // 产品名称
            "product_type":1, // 产品类型
            "product_desc":"0", // 产品描述
            "price":0, // 产品价格
            "cost":0,
            "created_at":"2020-06-29T03:17:00.000Z",
            "updated_at":"2020-06-29T03:32:12.000Z",
            "deleted_at":null,
            "version":0
        },
        {
            "id":7,
            "source_id":10001,
            "product_name":"ssda",
            "product_type":0,
            "product_desc":"0",
            "price":0,
            "cost":0,
            "created_at":"2020-06-29T11:31:35.000Z",
            "updated_at":"2020-06-29T11:31:41.000Z",
            "deleted_at":null,
            "version":0
        }],
    "requestid":"d71d44c5c285435784ff386dc0024be7"
}

```

## **<a name="getItems"> 获取组合产品子产品列表 </a>**

[返回到目录](#menu)

#### 参数格式 `JSON`

#### HTTP 请求方式 `POST`

#### 接口地址 `/api/op/product/etag`

#### action_type `getItems`

#### 参数说明

| 参数名 | 参数类型 | 必选项 | 备注        |
| ------ | -------- | ------ | ----------- |
| id     | number   | 必选   | 组合商品 id |

#### 参数示例

```javascript
{
  "id": 6
}
```

#### 返回结果

```javascript
{
    "status":0,
    "msg":"success",
    "data":[
        {
            "id":1,
            "source_id":10001,
            "product_name":"ss", // 产品名称
            "product_type":0, // 产品类型
            "product_desc":"0", // 产品描述
            "price":0, // 产品价格
            "cost":0,
            "created_at":"2020-06-28T17:37:28.000Z",
            "updated_at":"2020-06-28T17:37:31.000Z",
            "deleted_at":null,
            "version":0
        },
        {
            "id":7,
            "source_id":10001,
            "product_name":"ssda",
            "product_type":0,
            "product_desc":"0",
            "price":0,
            "cost":0,
            "created_at":"2020-06-29T11:31:35.000Z",
            "updated_at":"2020-06-29T11:31:41.000Z",
            "deleted_at":null,
            "version":0
        }],
    "requestid":"91c226b3a1024cc5a78dc25acb27ff46"
}

```

## **<a name="createOrUpdate"> 添加/更新产品 </a>**

[返回到目录](#menu)

#### 参数格式 `JSON`

#### HTTP 请求方式 `POST`

#### 接口地址 `/api/op/product/etag`

#### actionType `createOrUpdate`

#### 参数说明

| 参数名       | 参数类型 | 必选项   | 备注                                                                             |
| ------------ | -------- | -------- | -------------------------------------------------------------------------------- |
| id           | number   | 可选     | 更新产品的主键 如果没有则为创建                                                  |
| source_id    | number   | 可选     | 产品来源 id 默认 10001                                                           |
| product_name | string   | 必选     | 产品名称                                                                         |
| product_type | number   | 必选     | 产品类型 0: 单产品 1: 组合产品                                                   |
| price        | number   | 可选     | 默认 0                                                                           |
| cost         | number   | 可选     | 默认 0                                                                           |
| api          | string   | 可选     |                                                                                  |
| items        | list     | 限定必选 | 子产品 id 列表 <br> 如果 product_type 为 1 则必有此项 <br> 如果为 0 则必没有此项 |

#### 参数示例

```javascript
{
     "source_id": 10001,
     "product_name": "testa",
     "product_type": 1,
     "product_desc": "testa",
     "price": 1,
     "cost": 0,
     "api": "testurla",
     "items":[8, 9, 10]
}
```

#### 返回结果

```javascript
{
    "status":0,
    "msg":"success",
    "data":{
    },
    "requestid":"e6f7a5e50e404296ad47c92f43a54de4"
}
```
