var system=require("../../system")
const http=require("http")
const querystring = require('querystring');
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl=system.getObject("web.oplogCtl");
class BusinessInfoCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(BusinessInfoCtl));
   }
   async findOneById(pobj,obj,req){
    var user = req.session.user;
    if(user){
      var id = obj.id;
      if(!id){
        return {code:-1,msg:"参数错误"};
      }
      try {
        var data = await this.service.dao.model.findOne({where:{id:id},raw:true});
        return {code:1,data:data};
      } catch (e) {
        console.log(e);
        //日志记录
        logCtl.error({
          optitle: "查询商机信息findOneById异常error",
          op: "base/controller/impl/businessinfoCtl.js",
          content: e.stack,
          clientIp: ""
        });
        return {code:-100,msg:"操作失败"};
      }
      
    }else{
      return {code:-200,msg:"用户数据为空"}
    }
   }
}
module.exports=BusinessInfoCtl ;
