var system = require("../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl = system.getObject("web.oplogCtl");
class SiteThemeCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(SiteThemeCtl));
  }
  async getTheme(qobj, pobj, req) {
    try {
      var sitetheme = pobj.siteTheme || "";
      if (!req.session.user) {
        return { code: -100, msg: "用户未登录" }
      }
      if (!sitetheme) {
        return { code: -101, msg: "主题参数有误" }
      }
      return await this.service.getThemeBySitetheme(sitetheme);
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "查询主题异常error",
        op: "/base/controller/impl/sitethemeCtl.js/getTheme",
        content: e.stack,
        clientIp: ""
      });
      return { code: -200, msg: "操作异常" }
    }
  }
}
module.exports = SiteThemeCtl;
