var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class TransactionspecialperformanceCtl extends CtlBase{
    constructor(){
      super(CtlBase.getServiceName(TransactionspecialperformanceCtl));
      this.companyS = system.getObject("service.companySve");
      //this.appS=system.getObject("service.appSve");
    }
    async findAndCountAll(queryobj, obj, req) {
      obj.codepath = req.codepath;
      if (req.session.user) {
        obj.uid = req.session.user.id;
      }
      if (req.codepath.indexOf("pmg") < 0 && req.companyid && req.companyid != "" && obj.search) {
        obj.search.createcompany_id = req.companyid;
      }
      var apps = await this.service.findAndCountAll(obj);
      return system.getResult2(apps, null);
    }
    async create(queryobj, qobj, req) {
      if (req && req.codepath) {
        qobj.codepath = req.codepath;
      }
      if (req && req.companyid && req.companyid != "") {
        qobj.createcompany_id = req.companyid;
      }
      if (req && req.session && req.session.user) {
        var userinfo = req.session.user;
        qobj.creator = userinfo.nickName;
        qobj.createuser_id = userinfo.id;
      }
      var vcode = await this.service.getBusUid("tsf");
      qobj["code"]=vcode;
      if(!qobj.orderNo){
        qobj["orderNo"]=1;
      }
      await this.clearProductCache(qobj.company_id, qobj.codepath, qobj);
      var rd = await this.service.create(qobj);
      return system.getResult2(rd, null);
    }
    async update(queryobj, qobj, req) {
      if (req.codepath) {
        qobj.codepath = req.codepath;
      }
      if (req && req.companyid && req.companyid != "") {
        qobj.createcompany_id = req.companyid;
      }
      await this.clearProductCache(qobj.company_id, qobj.codepath, qobj);
      qobj.updator = qobj.nickName;
      qobj.updateuser_id = qobj.id;
      var rd = await this.service.update(qobj);
      return system.getResult2(rd, null);
    }
    //更改发布状态
    async changePublishStatus(qobj,obj,req){
      var user = req.session.user;
      if(user){
        obj["user"]=user;
        try {
          return this.service.changePublishStatus(obj);
        } catch (error) {
          return {code:-200,msg:"操作失败"};
        }
      }else{
        return {code:-100,msg:"用户数据为空"};
      }
    }
    //获取专场数据(通过站点主题)
    async getSpecialPerformanceBySiteTheme(obj,req){
      if(!obj.company_id){
        //获取当前域名
        var hostname = req.hostname;
        // console.log("xccccccccccccccccccccccccccccccccccccccc", hostname);
        //按照hostname去查找公司站点信息
        var companytmp = await this.companyS.findOne({ domainname: hostname, isEnabled: true });
        if(companytmp){
          obj.company_id=companytmp.id;
        }
      }
      try {
        return this.service.getSpecialPerformanceBySiteTheme(obj);
      } catch (error) {
        return {code:-200,msg:"操作失败"};
      }
    }
}
module.exports=TransactionspecialperformanceCtl;
// var task = new TransactionspecialperformanceCtl();
// var obj={company_id:4,siteTheme:"autumn",limit:4};
// task.getSpecialPerformanceBySiteTheme(obj).then(d=>{
//   console.log("dddddddddddddddddddddddddddd");
//   console.log(d);
// });