var system = require("../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../config/settings");
const CtlBase = require("../ctl.base");
const logCtl = system.getObject("web.oplogCtl");
class wxappCtl extends CtlBase {
  constructor() {
    super(CtlBase.getServiceName(wxappCtl));
    this.userSve = system.getObject("service.userSve");
    this.companySve = system.getObject("service.companySve");
  }
  async getWxappInfo(obj,req){
    var user = req.session.user;
    if(user && user.company_id){
      try {
        var wxapp = await this.service.dao.model.findOne({
          where:{company_id:user.company_id,authorized_status:"authorized"},
          attributes: ["id", "appid", "authorized_status", "authorized_status_name", "nick_name","head_img","principal_name","qrcode_url"],
          raw:true
        });
        if(wxapp && wxapp.id){
          return {code:1,data:wxapp};
        }else{
          return {code:-1,msg:"未知公众号"};
        }
      } catch (e) {

        return {code:-200,msg:"操作失败",errMsg:e.stack};
      }
    }else{
      return {code:-100,msg:"用户未登录"};
    }
  }
}
module.exports = wxappCtl;
