const CacheBase=require("../cache.base");
const system=require("../../system");
//缓存首次登录的赠送的宝币数量
class PConfigCache extends CacheBase{
   constructor(){
     super();
     this.prefix="g_pconfig";
     this.pConfigDao=system.getObject("db.pconfigDao");
     this.desc="平台配置参数!"
   }
   async cachePConfig(){
       const key=this.prefix;
       var configValue=await this.redisClient.get(key);
       if(!configValue || configValue=="undefined"){
         console.log("uiconfig no cache....");
         const configValue=await this.pConfigDao.model.findAll({attributes:["name","configType","configValue"],raw:true});
         var s=JSON.stringify(configValue);
         await this.redisClient.set(key,s);
         return configValue;
       }else {
         console.log("uiconfig already cache....");
       }
       return JSON.parse(configValue);
   }
   async invalidateCache(){
       const key=this.prefix;
       await this.redisClient.delete(key);
   }
}
module.exports=PConfigCache;
