const system = require("../../system");
const Dao = require("../dao.base");
class companyDao extends Dao {
  constructor() {
    super(Dao.getModelName(companyDao));
  }
  async getItemByOlnyCode(onlyCode) {
    return this.model.findOne({ where: { onlyCode: onlyCode }, raw: true, });
  }
  async getItemById(id) {
    return this.model.findOne({ where: { id: id }, raw: true, });
  }
  async getCompanyInfoByHostname(hostname) {//按照hostname去查找公司站点信息
    return await this.model.findOne({
      where: { domainname: hostname, isEnabled: true },
      attributes: ["id", "sitename", "domainname", "onlyCode", "sitetheme_id", "siteTheme"], raw: true
    });
  }
  extraModelFilter(){
    //return {"key":"include","value":[{model:this.db.models.app,},{model:this.db.models.role,as:"Roles",attributes:["id","name"],joinTableAttributes:['created_at']}]};
    return {"key":"include","value":[{model:this.db.models.weblink,as:"weblinks",attributes:["id","name","url"]}]};
  }
  async preUpdate(u){
    if(u.weblinks && u.weblinks.length>0){
      var weblinks=await this.db.models.weblink.findAll({where:{id:{[this.db.Op.in]:u.weblinks}}});
      console.log("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
      console.log(weblinks);
      u.weblinks=weblinks
    }
    return u;
  }
  async update(obj){
    var obj2=await this.preUpdate(obj);
    console.log("update....................");
    console.log(obj2);
    await this.model.update(obj2,{where:{id:obj2.id}});
    var user=await this.model.findOne({where:{id:obj2.id}});
    if(obj2.weblinks){
      user.setWeblinks(obj2.weblinks);
    }
    return user;
  }
}
module.exports = companyDao;
