const system = require("../../system");
const Dao = require("../dao.base");
class CustomerInfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(CustomerInfoDao));
  }
  async findOneByCode(code) {
    return this.model.findOne({ "where": { "code": code } });
  }
  async findOneByCodeAndUserId(code, owner_id) {
    return this.model.findOne({
      "where": { "code": code, "owner_id": owner_id },
      attributes: ["id",
        "applyAddr",
        "customerTypeName",
        "customerType",
        "identityCardPic",
        "businessLicensePic",
        "isLastOp",
        "name",
        "code",
        "company_id",
        "identityCardNo",
        "owner_id"], raw: true
    });
  }
  extraWhere(obj, w) {
    // console.log("---------------------------------------------------------------------------------zhangjiao");
    // console.log(obj);
    if (obj.codepath && obj.codepath != "") {
      if (obj.codepath.indexOf("my") >= 0) {
        //如果是我的订单，查询条件是订单等于当前登录人的onlyCode
        w["owner_id"] = obj.uid;
      }
    }
    return w;
  }
  extraModelFilter() {
    return {
      "key": "include", "value": [
        {
          model: this.db.models.customercontacts, as: "customercontacts",
          attributes: ["id", "mobile", "name"]
        }
      ]
    };
  }
  // async findAndCountAll(qobj){
  //   console.log(qobj);
  //   var qc = super.buildQuery(qobj);
  //   console.log(qc);
  //   var countsql="SELECT count(`id`) AS `count` FROM `biz_customerinfo`  WHERE `deleted_at` IS NULL ";
  //   var allsql="SELECT `customerinfo`.*, `customercontacts`.`id` AS `customercontacts.id`, "+
  //   "`customercontacts`.`mobile` AS `customercontacts.mobile`, `customercontacts`.`name` AS `customercontacts.name` "+
  //   "FROM (SELECT `customerinfo`.* FROM `biz_customerinfo` AS `customerinfo` "+
  //   "WHERE ((`customerinfo`.`deleted_at` IS NULL and NOT EXISTS (SELECT 1 FROM biz_customerinfo where customerinfo.name = name AND customerinfo.id < id) ) ";
  //   var whereParams=qc.where || {};
  //   if(whereParams){
  //     for(var p in whereParams){
  //       allsql = allsql + " AND "+p+"="+whereParams[p];
  //       countsql = countsql +" AND "+p+"="+whereParams[p];
  //     }
  //   }
  //   allsql = allsql+" ) ORDER BY `customerinfo`.`created_at` DESC ";
  //   var start=0;
  //   var limit=10;
  //   if(qc.limit){
  //     limit=qc.limit;
  //   }
  //   if(qc.offset){
  //     start=qc.offset;
  //   }
  //   allsql = allsql+"limit "+start+","+limit;
  //   allsql = allsql + " ) AS `customerinfo`"+
  //   " LEFT OUTER JOIN `biz_customercontacts` AS `customercontacts` ON "+
  //   "`customerinfo`.`id` = `customercontacts`.`customerinfo_id` AND (`customercontacts`.`deleted_at` IS NULL) ORDER BY `customerinfo`.`created_at` DESC";
  //   console.log(countsql);
  //   console.log(allsql);
  //   var count=await super.customQuery(countsql);
  //   var all=await super.customQuery(allsql);
  //   console.log(all);
  //   console.log(count);
  //   var rtn = {count:0,results:{}};
  //   rtn.count=count[0].count;
  //   rtn.results["rows"]=all;
  //   console.log(rtn);
  //   var rows = rtn.results.rows;

  //   return rtn;
  // }
  async findAndCountAll(qobj) {
    var qc = super.buildQuery(qobj);
    var apps = await this.model.findAndCountAll(qc);
    var aggresult = await this.findAggs(qobj, qc);
    var rtn = {};
    rtn.results = apps;
    rtn.aggresult = aggresult;
    var rows = rtn.results.rows;
    for (var i = 0; i < rows.length; i++) {
      var customer = rows[i];
      if (customer.customerType == "ent") {
        rtn.results.rows[i].dataValues["certificatesNo"] = customer.code;
      } else if (customer.customerType == "person") {
        rtn.results.rows[i].dataValues["certificatesNo"] = customer.identityCardNo;
      }
      var customercontact = {};
      if (customer.customercontacts.length > 0) {
        customercontact = customer.customercontacts[0];
      }
      rtn.results.rows[i].dataValues["customercontact"] = customercontact;
    }
    return rtn;
  }
}
module.exports = CustomerInfoDao;
